/*
 * Decompiled with CFR 0.152.
 */
package com.github.leonardoxh.keystore;

import android.content.Context;
import com.github.leonardoxh.keystore.CipherPreferencesStorage;
import com.github.leonardoxh.keystore.CipherStorage;
import com.github.leonardoxh.keystore.KeyStoreAccessException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

abstract class BaseCipherStorage
implements CipherStorage {
    static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    final Context context;

    BaseCipherStorage(Context context) {
        this.context = context;
    }

    @Override
    public boolean containsAlias(String alias) {
        try {
            KeyStore keyStore = BaseCipherStorage.getKeyStoreAndLoad();
            return keyStore.containsAlias(alias) && CipherPreferencesStorage.containsAlias(this.context, alias);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Failed to access Keystore", e);
        }
    }

    @Override
    public void removeKey(String alias) {
        try {
            if (this.containsAlias(alias)) {
                KeyStore keyStore = BaseCipherStorage.getKeyStoreAndLoad();
                keyStore.deleteEntry(alias);
                CipherPreferencesStorage.remove(this.context, alias);
            }
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Failed to access Keystore", e);
        }
    }

    @Override
    public void saveOrReplace(String alias, String value) {
        if (this.containsAlias(alias)) {
            this.removeKey(alias);
        }
        this.encrypt(alias, value);
    }

    static KeyStore getKeyStoreAndLoad() {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
            keyStore.load(null);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreAccessException("Could not access Keystore", e);
        }
    }
}

