/*
 * Decompiled with CFR 0.152.
 */
package com.github.leonardoxh.keystore;

import android.annotation.TargetApi;
import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import com.github.leonardoxh.keystore.BaseCipherStorage;
import com.github.leonardoxh.keystore.CipherPreferencesStorage;
import com.github.leonardoxh.keystore.CryptoFailedException;
import com.github.leonardoxh.keystore.KeyStoreAccessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

@TargetApi(value=23)
final class CipherStorageAndroidKeystore
extends BaseCipherStorage {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String ENCRYPTION_BLOCK_MODE = "CBC";
    private static final String ENCRYPTION_PADDING = "PKCS7Padding";
    private static final String ENCRYPTION_TRANSFORMATION = "AES/CBC/PKCS7Padding";
    private static final int ENCRYPTION_KEY_SIZE = 256;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    CipherStorageAndroidKeystore(Context context) {
        super(context);
    }

    @Override
    public void encrypt(String alias, String value) {
        try {
            KeyStore keyStore = CipherStorageAndroidKeystore.getKeyStoreAndLoad();
            KeyGenerator generator = KeyGenerator.getInstance(ENCRYPTION_ALGORITHM, "AndroidKeyStore");
            generator.init(CipherStorageAndroidKeystore.generateParameterSpec(alias));
            generator.generateKey();
            Key key = keyStore.getKey(alias, null);
            byte[] encryptedData = CipherStorageAndroidKeystore.encryptString(key, value);
            CipherPreferencesStorage.saveKeyBytes(this.context, alias, encryptedData);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new CryptoFailedException("Could not encrypt data", e);
        }
        catch (KeyStoreAccessException | KeyStoreException e) {
            throw new CryptoFailedException("Could not access Keystore", e);
        }
    }

    @Override
    @Nullable
    public String decrypt(String alias) {
        try {
            KeyStore keyStore = CipherStorageAndroidKeystore.getKeyStoreAndLoad();
            Key key = keyStore.getKey(alias, null);
            byte[] storedData = CipherPreferencesStorage.getKeyBytes(this.context, alias);
            if (storedData == null) {
                return null;
            }
            return CipherStorageAndroidKeystore.decryptBytes(key, storedData);
        }
        catch (KeyStoreAccessException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            return null;
        }
    }

    private static AlgorithmParameterSpec generateParameterSpec(String alias) {
        return new KeyGenParameterSpec.Builder(alias, 3).setBlockModes(new String[]{ENCRYPTION_BLOCK_MODE}).setEncryptionPaddings(new String[]{ENCRYPTION_PADDING}).setRandomizedEncryptionRequired(true).setKeySize(256).build();
    }

    private static String decryptBytes(Key key, byte[] bytes) throws CryptoFailedException {
        try {
            int n;
            Cipher cipher = Cipher.getInstance(ENCRYPTION_TRANSFORMATION);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            IvParameterSpec ivParams = CipherStorageAndroidKeystore.readIvFromStream(inputStream);
            cipher.init(2, key, ivParams);
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((n = cipherInputStream.read(buffer, 0, buffer.length)) > 0) {
                output.write(buffer, 0, n);
            }
            return new String(output.toByteArray(), DEFAULT_CHARSET);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Could not decrypt bytes", e);
        }
    }

    private static IvParameterSpec readIvFromStream(ByteArrayInputStream inputStream) {
        byte[] iv = new byte[16];
        inputStream.read(iv, 0, iv.length);
        return new IvParameterSpec(iv);
    }

    private static byte[] encryptString(Key key, String value) throws CryptoFailedException {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_TRANSFORMATION);
            cipher.init(1, key);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] iv = cipher.getIV();
            outputStream.write(iv, 0, iv.length);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            cipherOutputStream.write(value.getBytes(DEFAULT_CHARSET));
            cipherOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoFailedException("Could not encrypt value", e);
        }
    }
}

