/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.adapter;

import com.github.lhotari.reactive.pulsar.internal.adapter.AdapterImplementationFactory;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

public interface MessageResult<T> {
    public static <T> MessageResult<T> acknowledge(MessageId messageId, T value) {
        return AdapterImplementationFactory.acknowledge(messageId, value);
    }

    public static <T> MessageResult<T> negativeAcknowledge(MessageId messageId, T value) {
        return AdapterImplementationFactory.negativeAcknowledge(messageId, value);
    }

    public static MessageResult<Void> acknowledge(MessageId messageId) {
        return AdapterImplementationFactory.acknowledge(messageId);
    }

    public static MessageResult<Void> negativeAcknowledge(MessageId messageId) {
        return AdapterImplementationFactory.negativeAcknowledge(messageId);
    }

    public static <V> MessageResult<Message<V>> acknowledgeAndReturn(Message<V> message) {
        return MessageResult.acknowledge(message.getMessageId(), message);
    }

    public boolean isAcknowledgeMessage();

    public MessageId getMessageId();

    public T getValue();
}

