/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.adapter;

import com.github.lhotari.reactive.pulsar.adapter.MessageResult;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageConsumer;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageHandler;
import com.github.lhotari.reactive.pulsar.internal.adapter.AdapterImplementationFactory;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.pulsar.client.api.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public interface ReactiveMessageHandlerBuilder<T> {
    public static <T> ReactiveMessageHandlerBuilder<T> builder(ReactiveMessageConsumer<T> messageConsumer) {
        return AdapterImplementationFactory.createReactiveMessageHandlerBuilder(messageConsumer);
    }

    public OneByOneMessageHandlerBuilder<T> messageHandler(Function<Message<T>, Mono<Void>> var1);

    public ReactiveMessageHandlerBuilder<T> streamingMessageHandler(Function<Flux<Message<T>>, Flux<MessageResult<Void>>> var1);

    public ReactiveMessageHandlerBuilder<T> transformPipeline(Function<Mono<Void>, Mono<Void>> var1);

    public ReactiveMessageHandlerBuilder<T> pipelineRetrySpec(Retry var1);

    public ReactiveMessageHandler build();

    public static interface ConcurrentOneByOneMessageHandlerBuilder<T>
    extends OneByOneMessageHandlerBuilder<T> {
        public ConcurrentOneByOneMessageHandlerBuilder<T> keyOrdered(boolean var1);

        public ConcurrentOneByOneMessageHandlerBuilder<T> concurrency(int var1);

        public ConcurrentOneByOneMessageHandlerBuilder<T> maxInflight(int var1);
    }

    public static interface OneByOneMessageHandlerBuilder<T>
    extends ReactiveMessageHandlerBuilder<T> {
        public OneByOneMessageHandlerBuilder<T> handlingTimeout(Duration var1);

        public OneByOneMessageHandlerBuilder<T> errorLogger(BiConsumer<Message<T>, Throwable> var1);

        public ConcurrentOneByOneMessageHandlerBuilder<T> concurrent();
    }
}

