/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.adapter;

import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageConsumerBuilder;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageReaderBuilder;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageSenderBuilder;
import com.github.lhotari.reactive.pulsar.internal.adapter.AdapterImplementationFactory;
import com.github.lhotari.reactive.pulsar.resourceadapter.ReactivePulsarResourceAdapter;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;

public interface ReactivePulsarClient {
    public static ReactivePulsarClient create(PulsarClient pulsarClient) {
        return ReactivePulsarClient.create(() -> pulsarClient);
    }

    public static ReactivePulsarClient create(Supplier<PulsarClient> pulsarClientSupplier) {
        return ReactivePulsarClient.create(ReactivePulsarResourceAdapter.create(pulsarClientSupplier));
    }

    public static ReactivePulsarClient create(ReactivePulsarResourceAdapter reactivePulsarResourceAdapter) {
        return AdapterImplementationFactory.createReactivePulsarClient(reactivePulsarResourceAdapter);
    }

    public <T> ReactiveMessageSenderBuilder<T> messageSender(Schema<T> var1);

    public <T> ReactiveMessageReaderBuilder<T> messageReader(Schema<T> var1);

    public <T> ReactiveMessageConsumerBuilder<T> messageConsumer(Schema<T> var1);
}

