/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.internal.adapter;

import com.github.lhotari.reactive.pulsar.adapter.MessageSpec;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.TypedMessageBuilder;

class DefaultMessageSpec<T>
implements MessageSpec<T> {
    private final String key;
    private final byte[] orderingKey;
    private final byte[] keyBytes;
    private final T value;
    private final Map<String, String> properties;
    private final Long eventTime;
    private final Long sequenceId;
    private final List<String> replicationClusters;
    private final boolean disableReplication;
    private final Long deliverAt;
    private final Long deliverAfterDelay;
    private final TimeUnit deliverAfterUnit;

    DefaultMessageSpec(String key, byte[] orderingKey, byte[] keyBytes, T value, Map<String, String> properties, Long eventTime, Long sequenceId, List<String> replicationClusters, boolean disableReplication, Long deliverAt, Long deliverAfterDelay, TimeUnit deliverAfterUnit) {
        this.key = key;
        this.orderingKey = orderingKey;
        this.keyBytes = keyBytes;
        this.value = value;
        this.properties = properties;
        this.eventTime = eventTime;
        this.sequenceId = sequenceId;
        this.replicationClusters = replicationClusters;
        this.disableReplication = disableReplication;
        this.deliverAt = deliverAt;
        this.deliverAfterDelay = deliverAfterDelay;
        this.deliverAfterUnit = deliverAfterUnit;
    }

    @Override
    public void configure(TypedMessageBuilder<T> typedMessageBuilder) {
        if (this.key != null) {
            typedMessageBuilder.key(this.key);
        }
        if (this.orderingKey != null) {
            typedMessageBuilder.orderingKey(this.orderingKey);
        }
        if (this.keyBytes != null) {
            typedMessageBuilder.keyBytes(this.keyBytes);
        }
        typedMessageBuilder.value(this.value);
        if (this.properties != null) {
            typedMessageBuilder.properties(this.properties);
        }
        if (this.eventTime != null) {
            typedMessageBuilder.eventTime(this.eventTime.longValue());
        }
        if (this.sequenceId != null) {
            typedMessageBuilder.sequenceId(this.sequenceId.longValue());
        }
        if (this.replicationClusters != null) {
            typedMessageBuilder.replicationClusters(this.replicationClusters);
        }
        if (this.disableReplication) {
            typedMessageBuilder.disableReplication();
        }
        if (this.deliverAt != null) {
            typedMessageBuilder.deliverAt(this.deliverAt.longValue());
        }
        if (this.deliverAfterDelay != null) {
            typedMessageBuilder.deliverAfter(this.deliverAfterDelay.longValue(), this.deliverAfterUnit);
        }
    }
}

