/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.internal.adapter;

import com.github.lhotari.reactive.pulsar.adapter.ProducerConfigurer;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageSender;
import com.github.lhotari.reactive.pulsar.adapter.ReactiveMessageSenderBuilder;
import com.github.lhotari.reactive.pulsar.internal.adapter.DefaultReactiveMessageSender;
import com.github.lhotari.reactive.pulsar.internal.adapter.InflightLimiter;
import com.github.lhotari.reactive.pulsar.resourceadapter.PublisherTransformer;
import com.github.lhotari.reactive.pulsar.resourceadapter.ReactiveProducerAdapterFactory;
import com.github.lhotari.reactive.pulsar.resourceadapter.ReactiveProducerCache;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Schema;
import reactor.core.scheduler.Schedulers;

class DefaultReactiveMessageSenderBuilder<T>
implements ReactiveMessageSenderBuilder<T> {
    private static final int MAX_CONCURRENCY_LOWER_BOUND = 32;
    private static final int MAX_CONCURRENCY_UPPER_BOUND = 256;
    private final Schema<T> schema;
    private final ReactiveProducerAdapterFactory reactiveProducerAdapterFactory;
    private ProducerConfigurer<T> producerConfigurer;
    private String topicName;
    private ReactiveProducerCache producerCache;
    private int maxInflight = -1;
    private int maxConcurrentSenderSubscriptions = 1024;
    private Supplier<PublisherTransformer> producerActionTransformer = PublisherTransformer::identity;

    public DefaultReactiveMessageSenderBuilder(Schema<T> schema, ReactiveProducerAdapterFactory reactiveProducerAdapterFactory) {
        this.schema = schema;
        this.reactiveProducerAdapterFactory = reactiveProducerAdapterFactory;
    }

    @Override
    public ReactiveMessageSenderBuilder<T> cache(ReactiveProducerCache producerCache) {
        this.producerCache = producerCache;
        return this;
    }

    @Override
    public ReactiveMessageSenderBuilder<T> producerConfigurer(ProducerConfigurer<T> producerConfigurer) {
        this.producerConfigurer = producerConfigurer;
        return this;
    }

    @Override
    public ReactiveMessageSenderBuilder<T> topic(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @Override
    public ReactiveMessageSenderBuilder<T> maxInflight(int maxInflight) {
        this.maxInflight = maxInflight;
        return this;
    }

    @Override
    public ReactiveMessageSenderBuilder<T> maxConcurrentSenderSubscriptions(int maxConcurrentSenderSubscriptions) {
        this.maxConcurrentSenderSubscriptions = maxConcurrentSenderSubscriptions;
        return this;
    }

    @Override
    public ReactiveMessageSender<T> build() {
        if (this.maxInflight > 0) {
            this.producerActionTransformer = () -> new InflightLimiter(this.maxInflight, Math.max(this.maxInflight / 2, 1), Schedulers.single(), this.maxConcurrentSenderSubscriptions);
        }
        return new DefaultReactiveMessageSender<T>(this.schema, this.producerConfigurer, this.topicName, this.resolveMaxConcurrency(), this.reactiveProducerAdapterFactory, this.producerCache, this.producerActionTransformer);
    }

    private int resolveMaxConcurrency() {
        return Math.min(Math.max(32, this.maxInflight / 2), 256);
    }
}

