/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.internal.resourceadapter;

import com.github.lhotari.reactive.pulsar.resourceadapter.ProducerCacheKey;
import java.util.Objects;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;

final class DefaultProducerCacheKey
implements ProducerCacheKey {
    private final PulsarClient pulsarClient;
    private final ProducerConfigurationData producerConfigurationData;
    private final Schema<?> schema;

    DefaultProducerCacheKey(PulsarClient pulsarClient, ProducerConfigurationData producerConfigurationData, Schema<?> schema) {
        this.pulsarClient = pulsarClient;
        this.producerConfigurationData = producerConfigurationData;
        this.schema = schema;
    }

    @Override
    public String getTopicName() {
        return this.producerConfigurationData != null ? this.producerConfigurationData.getTopicName() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProducerCacheKey that = (DefaultProducerCacheKey)o;
        return Objects.equals(this.pulsarClient, that.pulsarClient) && Objects.equals(this.producerConfigurationData, that.producerConfigurationData) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.pulsarClient, this.producerConfigurationData, this.schema);
    }
}

