/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.internal.resourceadapter;

import com.github.lhotari.reactive.pulsar.internal.adapter.AdapterImplementationFactory;
import com.github.lhotari.reactive.pulsar.internal.resourceadapter.DefaultProducerCacheKey;
import com.github.lhotari.reactive.pulsar.resourceadapter.ProducerCacheKey;
import com.github.lhotari.reactive.pulsar.resourceadapter.PublisherTransformer;
import com.github.lhotari.reactive.pulsar.resourceadapter.ReactiveProducerAdapter;
import com.github.lhotari.reactive.pulsar.resourceadapter.ReactiveProducerCache;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class DefaultReactiveProducerAdapter<T>
implements ReactiveProducerAdapter<T> {
    private final ReactiveProducerCache producerCache;
    private final Function<PulsarClient, ProducerBuilder<T>> producerBuilderFactory;
    private final Supplier<PulsarClient> pulsarClientSupplier;
    private Supplier<PublisherTransformer> producerActionTransformer;

    public DefaultReactiveProducerAdapter(Supplier<PulsarClient> pulsarClientSupplier, Function<PulsarClient, ProducerBuilder<T>> producerBuilderFactory, ReactiveProducerCache producerCache, Supplier<PublisherTransformer> producerActionTransformer) {
        this.pulsarClientSupplier = pulsarClientSupplier;
        this.producerBuilderFactory = producerBuilderFactory;
        this.producerCache = producerCache;
        this.producerActionTransformer = producerActionTransformer;
    }

    private Mono<Producer<T>> createProducerMono() {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> this.producerBuilderFactory.apply(this.pulsarClientSupplier.get()).createAsync());
    }

    private Mono<Tuple2<DefaultProducerCacheKey, Mono<Producer<T>>>> createCachedProducerKeyAndMono() {
        return Mono.fromCallable(() -> {
            PulsarClient pulsarClient = this.pulsarClientSupplier.get();
            ProducerBuilderImpl producerBuilder = (ProducerBuilderImpl)this.producerBuilderFactory.apply(pulsarClient);
            DefaultProducerCacheKey cacheKey = new DefaultProducerCacheKey(pulsarClient, producerBuilder.getConf().clone(), producerBuilder.getSchema());
            return Tuples.of((Object)cacheKey, AdapterImplementationFactory.adaptPulsarFuture(() -> ((ProducerBuilderImpl)producerBuilder).createAsync()));
        });
    }

    private Mono<Void> closeProducer(Producer<?> producer) {
        return AdapterImplementationFactory.adaptPulsarFuture(() -> producer.closeAsync());
    }

    @Override
    public <R> Mono<R> usingProducer(Function<Producer<T>, Mono<R>> usingProducerAction) {
        if (this.producerCache != null) {
            return this.usingCachedProducer(usingProducerAction);
        }
        return this.usingUncachedProducer(usingProducerAction);
    }

    private <R> Mono<R> usingUncachedProducer(Function<Producer<T>, Mono<R>> usingProducerAction) {
        return Mono.usingWhen(this.createProducerMono(), producer -> Mono.using(() -> this.producerActionTransformer.get(), transformer -> (Mono)((Mono)usingProducerAction.apply((Producer)producer)).as(mono -> Mono.from(transformer.transform(mono))), Disposable::dispose), this::closeProducer);
    }

    private <R> Mono<R> usingCachedProducer(Function<Producer<T>, Mono<R>> usingProducerAction) {
        return this.createCachedProducerKeyAndMono().flatMap(keyAndProducerMono -> {
            ProducerCacheKey cacheKey = (ProducerCacheKey)keyAndProducerMono.getT1();
            Mono producerMono = (Mono)keyAndProducerMono.getT2();
            return this.producerCache.usingCachedProducer(cacheKey, producerMono, this.producerActionTransformer, usingProducerAction);
        });
    }

    @Override
    public <R> Flux<R> usingProducerMany(Function<Producer<T>, Flux<R>> usingProducerAction) {
        if (this.producerCache != null) {
            return this.usingCachedProducerMany(usingProducerAction);
        }
        return this.usingUncachedProducerMany(usingProducerAction);
    }

    private <R> Flux<R> usingUncachedProducerMany(Function<Producer<T>, Flux<R>> usingProducerAction) {
        return Flux.usingWhen(this.createProducerMono(), producer -> Flux.using(() -> this.producerActionTransformer.get(), transformer -> (Publisher)((Flux)usingProducerAction.apply((Producer)producer)).as(transformer::transform), Disposable::dispose), this::closeProducer);
    }

    private <R> Flux<R> usingCachedProducerMany(Function<Producer<T>, Flux<R>> usingProducerAction) {
        return this.createCachedProducerKeyAndMono().flatMapMany(keyAndProducerMono -> {
            ProducerCacheKey cacheKey = (ProducerCacheKey)keyAndProducerMono.getT1();
            Mono producerMono = (Mono)keyAndProducerMono.getT2();
            return this.producerCache.usingCachedProducerMany(cacheKey, producerMono, this.producerActionTransformer, usingProducerAction);
        });
    }
}

