/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.spring;

import com.github.lhotari.reactive.pulsar.spring.DefaultPulsarTopicNameResolver;
import com.github.lhotari.reactive.pulsar.spring.PulsarClientConfig;
import com.github.lhotari.reactive.pulsar.spring.PulsarTopicNameResolver;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientBuilderImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfiguration
@EnableConfigurationProperties(value={PulsarClientConfig.class})
public class PulsarClientAutoConfiguration {
    @Lazy
    @Bean
    @ConditionalOnMissingBean
    PulsarClient pulsarClient(PulsarClientConfig pulsarClientConfig) throws PulsarClientException {
        return new ClientBuilderImpl((ClientConfigurationData)pulsarClientConfig).build();
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarTopicNameResolver pulsarTopicNameResolver(@Value(value="${pulsar.topicNamePrefix:persistent://public/default/}") String pulsarTopicPrefix) {
        return new DefaultPulsarTopicNameResolver(pulsarTopicPrefix);
    }
}

