/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.spring;

import java.util.Map;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="pulsar.client")
public class PulsarClientConfig
extends ClientConfigurationData
implements InitializingBean {
    public PulsarClientConfig() {
        this.setServiceUrl("pulsar://localhost:6650/");
    }

    void setIoThreads(int ioThreads) {
        this.setNumIoThreads(ioThreads);
    }

    void setListenerThreads(int listenerThreads) {
        this.setNumListenerThreads(listenerThreads);
    }

    void setMaxLookupRequests(int maxLookupRequests) {
        this.setMaxLookupRequest(maxLookupRequests);
    }

    void setMaxConcurrentLookupRequests(int maxConcurrentLookupRequests) {
        this.setConcurrentLookupRequest(maxConcurrentLookupRequests);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getAuthPluginClassName() != null) {
            if (this.getAuthParams() != null) {
                this.setAuthentication(AuthenticationFactory.create((String)this.getAuthPluginClassName(), (String)this.getAuthParams()));
            } else if (this.getAuthParamMap() != null) {
                this.setAuthentication(AuthenticationFactory.create((String)this.getAuthPluginClassName(), (Map)this.getAuthParamMap()));
            }
        }
    }
}

