/*
 * Decompiled with CFR 0.152.
 */
package com.github.lhotari.reactive.pulsar.spring.test;

import java.util.HashMap;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class SingletonPulsarContainer {
    private static final String PULSAR_CONTAINER_IMAGE = System.getenv().getOrDefault("PULSAR_CONTAINER_IMAGE", "apachepulsar/pulsar:2.10.2");
    public static SingletonPulsarContainer INSTANCE = new SingletonPulsarContainer();
    private final PulsarContainer pulsarContainer = new PulsarContainer(DockerImageName.parse((String)PULSAR_CONTAINER_IMAGE).asCompatibleSubstituteFor("apachepulsar/pulsar")){

        protected void configure() {
            super.configure();
            new WaitAllStrategy().withStrategy(this.waitStrategy).withStrategy((WaitStrategy)Wait.forHttp((String)"/admin/v2/namespaces/public/default").forPort(8080));
            this.withLabel("reactive-pulsar.container", "true");
            this.withReuse(true);
            this.withEnv("PULSAR_GC", "-XX:+UseG1GC");
        }
    };

    public static void register(DynamicPropertyRegistry registry) {
        INSTANCE.registerToSpringTest(registry);
    }

    private SingletonPulsarContainer() {
        this.pulsarContainer.start();
    }

    private void registerToSpringTest(DynamicPropertyRegistry registry) {
        this.registerPulsarProperties(registry);
        this.registerTestTopicPrefix(registry);
    }

    private void registerPulsarProperties(DynamicPropertyRegistry registry) {
        registry.add("pulsar.client.serviceUrl", () -> ((PulsarContainer)this.pulsarContainer).getPulsarBrokerUrl());
        registry.add("pulsar.admin.serviceHttpUrl", () -> ((PulsarContainer)this.pulsarContainer).getHttpServiceUrl());
    }

    private void registerTestTopicPrefix(DynamicPropertyRegistry registry) {
        registry.add("pulsar.topicNamePrefix", this::createTestTopicPrefix);
    }

    private String createTestTopicPrefix() {
        return "test" + System.currentTimeMillis() / 1000L + "_";
    }

    public PulsarContainer getPulsarContainer() {
        return this.pulsarContainer;
    }

    public static class ContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            HashMap applicationProperties = new HashMap();
            SingletonPulsarContainer.register((name, valueSupplier) -> applicationProperties.put(name, valueSupplier.get()));
            MapPropertySource propertySource = new MapPropertySource(this.getClass().getName(), applicationProperties);
            applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

