/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.config;

import com.github.lianjiatech.retrofit.spring.boot.config.PoolConfig;
import com.github.lianjiatech.retrofit.spring.boot.core.BodyCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.ResponseCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseResourceNameParser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DefaultResourceNameParser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeType;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseLoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.DefaultLoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.BaseRetryInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.DefaultRetryInterceptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.converter.jackson.JacksonConverterFactory;

@ConfigurationProperties(prefix="retrofit")
public class RetrofitProperties {
    private static final String DEFAULT_POOL = "default";
    private Map<String, PoolConfig> pool = new LinkedHashMap<String, PoolConfig>();
    private boolean enableLog = true;
    private boolean enableDegrade = false;
    private DegradeType degradeType = DegradeType.SENTINEL;
    private Class<? extends BaseResourceNameParser> resourceNameParser = DefaultResourceNameParser.class;
    private Class<? extends BaseLoggingInterceptor> loggingInterceptor = DefaultLoggingInterceptor.class;
    private Class<? extends BaseRetryInterceptor> retryInterceptor = DefaultRetryInterceptor.class;
    private boolean disableVoidReturnType = false;
    private Class<? extends Converter.Factory>[] globalConverterFactories = new Class[]{JacksonConverterFactory.class};
    private Class<? extends CallAdapter.Factory>[] globalCallAdapterFactories = new Class[]{BodyCallAdapterFactory.class, ResponseCallAdapterFactory.class};

    public Class<? extends BaseLoggingInterceptor> getLoggingInterceptor() {
        return this.loggingInterceptor;
    }

    public void setLoggingInterceptor(Class<? extends BaseLoggingInterceptor> loggingInterceptor) {
        this.loggingInterceptor = loggingInterceptor;
    }

    public Map<String, PoolConfig> getPool() {
        if (!this.pool.isEmpty()) {
            return this.pool;
        }
        this.pool.put(DEFAULT_POOL, new PoolConfig(5, 300L));
        return this.pool;
    }

    public void setPool(Map<String, PoolConfig> pool) {
        this.pool = pool;
    }

    public boolean isEnableLog() {
        return this.enableLog;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public boolean isDisableVoidReturnType() {
        return this.disableVoidReturnType;
    }

    public void setDisableVoidReturnType(boolean disableVoidReturnType) {
        this.disableVoidReturnType = disableVoidReturnType;
    }

    public Class<? extends BaseRetryInterceptor> getRetryInterceptor() {
        return this.retryInterceptor;
    }

    public void setRetryInterceptor(Class<? extends BaseRetryInterceptor> retryInterceptor) {
        this.retryInterceptor = retryInterceptor;
    }

    public Class<? extends Converter.Factory>[] getGlobalConverterFactories() {
        return this.globalConverterFactories;
    }

    public void setGlobalConverterFactories(Class<? extends Converter.Factory>[] globalConverterFactories) {
        this.globalConverterFactories = globalConverterFactories;
    }

    public Class<? extends CallAdapter.Factory>[] getGlobalCallAdapterFactories() {
        return this.globalCallAdapterFactories;
    }

    public void setGlobalCallAdapterFactories(Class<? extends CallAdapter.Factory>[] globalCallAdapterFactories) {
        this.globalCallAdapterFactories = globalCallAdapterFactories;
    }

    public boolean isEnableDegrade() {
        return this.enableDegrade;
    }

    public void setEnableDegrade(boolean enableDegrade) {
        this.enableDegrade = enableDegrade;
    }

    public DegradeType getDegradeType() {
        return this.degradeType;
    }

    public void setDegradeType(DegradeType degradeType) {
        this.degradeType = degradeType;
    }

    public Class<? extends BaseResourceNameParser> getResourceNameParser() {
        return this.resourceNameParser;
    }

    public void setResourceNameParser(Class<? extends BaseResourceNameParser> resourceNameParser) {
        this.resourceNameParser = resourceNameParser;
    }
}

