/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.degrade.FallbackFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class RetrofitInvocationHandler
implements InvocationHandler {
    private final Object source;
    private final RetrofitProperties retrofitProperties;
    private Object fallback;
    private FallbackFactory<?> fallbackFactory;

    public RetrofitInvocationHandler(Object source, Object fallback, FallbackFactory<?> fallbackFactory, RetrofitProperties retrofitProperties) {
        this.source = source;
        this.retrofitProperties = retrofitProperties;
        this.fallback = fallback;
        this.fallbackFactory = fallbackFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.source, args);
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            Object fallbackObject = this.getFallbackObject(cause);
            if (cause instanceof RetrofitBlockException && this.retrofitProperties.isEnableDegrade() && fallbackObject != null) {
                return method.invoke(fallbackObject, args);
            }
            throw cause;
        }
    }

    private Object getFallbackObject(Throwable cause) {
        if (this.fallback != null) {
            return this.fallback;
        }
        if (this.fallbackFactory != null) {
            return this.fallbackFactory.create(cause);
        }
        return null;
    }
}

