/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseDegradeInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SentinelDegradeInterceptor
extends BaseDegradeInterceptor {
    @Override
    protected Response degradeIntercept(String resourceName, Interceptor.Chain chain) throws RetrofitBlockException, IOException {
        Request request = chain.request();
        Entry entry = null;
        try {
            entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.OUT);
            Response response = chain.proceed(request);
            return response;
        }
        catch (BlockException e) {
            throw new RetrofitBlockException(e);
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

