/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.log;

import com.github.lianjiatech.retrofit.spring.boot.log.GlobalLogProperty;
import com.github.lianjiatech.retrofit.spring.boot.log.LogLevel;
import com.github.lianjiatech.retrofit.spring.boot.log.LogStrategy;
import com.github.lianjiatech.retrofit.spring.boot.log.Logging;
import com.github.lianjiatech.retrofit.spring.boot.util.AnnotationExtendUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Invocation;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);
    protected final GlobalLogProperty globalLogProperty;

    public LoggingInterceptor(GlobalLogProperty globalLogProperty) {
        this.globalLogProperty = globalLogProperty;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Logging logging = this.findLogging(chain);
        if (!this.needLog(logging)) {
            return chain.proceed(chain.request());
        }
        LogLevel logLevel = logging == null ? this.globalLogProperty.getLogLevel() : logging.logLevel();
        LogStrategy logStrategy = logging == null ? this.globalLogProperty.getLogStrategy() : logging.logStrategy();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(this.matchLogger(logLevel)).setLevel(HttpLoggingInterceptor.Level.valueOf((String)logStrategy.name()));
        return httpLoggingInterceptor.intercept(chain);
    }

    protected Logging findLogging(Interceptor.Chain chain) {
        Method method = Objects.requireNonNull((Invocation)chain.request().tag(Invocation.class)).method();
        return AnnotationExtendUtils.findMergedAnnotation(method, method.getDeclaringClass(), Logging.class);
    }

    protected boolean needLog(Logging logging) {
        if (this.globalLogProperty.isEnable()) {
            if (logging == null) {
                return true;
            }
            return logging.enable();
        }
        return logging != null && logging.enable();
    }

    protected HttpLoggingInterceptor.Logger matchLogger(LogLevel level) {
        if (level == LogLevel.DEBUG) {
            return arg_0 -> ((Logger)log).debug(arg_0);
        }
        if (level == LogLevel.ERROR) {
            return arg_0 -> ((Logger)log).error(arg_0);
        }
        if (level == LogLevel.INFO) {
            return arg_0 -> ((Logger)log).info(arg_0);
        }
        if (level == LogLevel.WARN) {
            return arg_0 -> ((Logger)log).warn(arg_0);
        }
        if (level == LogLevel.TRACE) {
            return arg_0 -> ((Logger)log).trace(arg_0);
        }
        throw new UnsupportedOperationException("We don't support this log level currently.");
    }
}

