/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.ClassPathRetrofitClientScanner;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitScan;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class RetrofitClientScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(RetrofitClientScannerRegistrar.class);
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(RetrofitScan.class.getName()));
        if (attributes == null) {
            return;
        }
        ClassPathRetrofitClientScanner scanner = new ClassPathRetrofitClientScanner(registry, this.classLoader);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        Object[] basePackages = this.getPackagesToScan(attributes);
        log.info("Scan the @RetrofitClient annotated interface using the @RetrofitScan configuration. packages={}", (Object)Arrays.toString(basePackages));
        scanner.registerFilters();
        scanner.doScan((String[])basePackages);
    }

    private String[] getPackagesToScan(AnnotationAttributes attributes) {
        Object[] value = attributes.getStringArray("value");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        if (!ObjectUtils.isEmpty((Object[])value)) {
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])basePackages), (String)"@RetrofitScan basePackages and value attributes are mutually exclusive");
        }
        LinkedHashSet<Object> packagesToScan = new LinkedHashSet<Object>();
        packagesToScan.addAll(Arrays.asList(value));
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        return packagesToScan.toArray(new String[0]);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

