/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.SourceOkHttpClientRegistrar;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.springframework.util.Assert;

public class SourceOkHttpClientRegistry {
    private final Map<String, OkHttpClient> okHttpClientMap;
    private final List<SourceOkHttpClientRegistrar> registrars;

    public SourceOkHttpClientRegistry(List<SourceOkHttpClientRegistrar> registrars) {
        this.registrars = registrars;
        this.okHttpClientMap = new HashMap<String, OkHttpClient>(4);
    }

    @PostConstruct
    public void init() {
        if (this.registrars == null) {
            return;
        }
        this.registrars.forEach(registrar -> registrar.register(this));
    }

    public void register(String name, OkHttpClient okHttpClient) {
        this.okHttpClientMap.put(name, okHttpClient);
    }

    public OkHttpClient get(String name) {
        OkHttpClient okHttpClient = this.okHttpClientMap.get(name);
        Assert.notNull((Object)okHttpClient, (String)("Specified OkHttpClient not found! name=" + name));
        return okHttpClient;
    }
}

