/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j;

import com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j.CircuitBreakerConfigRegistrar;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class CircuitBreakerConfigRegistry {
    private final Map<String, CircuitBreakerConfig> circuitBreakerConfigMap = new HashMap<String, CircuitBreakerConfig>(8);
    private final List<CircuitBreakerConfigRegistrar> registrars;

    public CircuitBreakerConfigRegistry(List<CircuitBreakerConfigRegistrar> registrars) {
        this.circuitBreakerConfigMap.put("defaultCircuitBreakerConfig", CircuitBreakerConfig.ofDefaults());
        this.registrars = registrars;
    }

    @PostConstruct
    public void init() {
        if (this.registrars == null) {
            return;
        }
        this.registrars.forEach(registrar -> registrar.register(this));
    }

    public void register(String name, CircuitBreakerConfig circuitBreakerConfig) {
        this.circuitBreakerConfigMap.put(name, circuitBreakerConfig);
    }

    public CircuitBreakerConfig get(String name) {
        CircuitBreakerConfig circuitBreakerConfig = this.circuitBreakerConfigMap.get(name);
        Assert.notNull((Object)circuitBreakerConfig, (String)("Specified CircuitBreakerConfig not found! name=" + name));
        return circuitBreakerConfig;
    }
}

