/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j;

import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitFactoryBean;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseRetrofitDegrade;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitBlockException;
import com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j.CircuitBreakerConfigRegistry;
import com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j.GlobalResilience4jDegradeProperty;
import com.github.lianjiatech.retrofit.spring.boot.degrade.resilience4j.Resilience4jDegrade;
import com.github.lianjiatech.retrofit.spring.boot.util.AnnotationExtendUtils;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.StopWatch;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import retrofit2.Invocation;

public class Resilience4jRetrofitDegrade
extends BaseRetrofitDegrade {
    private static final Logger log = LoggerFactory.getLogger(Resilience4jRetrofitDegrade.class);
    protected final CircuitBreakerRegistry circuitBreakerRegistry;
    protected final GlobalResilience4jDegradeProperty globalResilience4jDegradeProperty;
    protected final CircuitBreakerConfigRegistry circuitBreakerConfigRegistry;

    public Resilience4jRetrofitDegrade(CircuitBreakerRegistry circuitBreakerRegistry, GlobalResilience4jDegradeProperty globalResilience4jDegradeProperty, CircuitBreakerConfigRegistry circuitBreakerConfigRegistry) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.globalResilience4jDegradeProperty = globalResilience4jDegradeProperty;
        this.circuitBreakerConfigRegistry = circuitBreakerConfigRegistry;
    }

    @Override
    public boolean isEnableDegrade(Class<?> retrofitInterface) {
        if (this.globalResilience4jDegradeProperty.isEnable()) {
            Resilience4jDegrade resilience4jDegrade = (Resilience4jDegrade)AnnotatedElementUtils.findMergedAnnotation(retrofitInterface, Resilience4jDegrade.class);
            if (resilience4jDegrade == null) {
                return true;
            }
            return resilience4jDegrade.enable();
        }
        return AnnotationExtendUtils.isAnnotationPresentIncludeMethod(retrofitInterface, Resilience4jDegrade.class);
    }

    @Override
    public void loadDegradeRules(Class<?> retrofitInterface, String baseUrl) {
        for (Method method : retrofitInterface.getMethods()) {
            Resilience4jDegrade resilience4jDegrade;
            if (this.isDefaultOrStatic(method) || !this.needDegrade(resilience4jDegrade = AnnotationExtendUtils.findMergedAnnotation(method, retrofitInterface, Resilience4jDegrade.class))) continue;
            String circuitBreakerConfigName = resilience4jDegrade == null ? this.globalResilience4jDegradeProperty.getCircuitBreakerConfigName() : resilience4jDegrade.circuitBreakerConfigName();
            this.circuitBreakerRegistry.circuitBreaker(this.parseResourceName(method, baseUrl), this.circuitBreakerConfigRegistry.get(circuitBreakerConfigName));
        }
    }

    protected boolean needDegrade(Resilience4jDegrade resilience4jDegrade) {
        if (this.globalResilience4jDegradeProperty.isEnable()) {
            if (resilience4jDegrade == null) {
                return true;
            }
            return resilience4jDegrade.enable();
        }
        return resilience4jDegrade != null && resilience4jDegrade.enable();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        CircuitBreaker circuitBreaker;
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        if (invocation == null) {
            return chain.proceed(request);
        }
        Class service = invocation.service();
        String baseUrl = RetrofitFactoryBean.BASE_URL_MAP.get(service);
        if (baseUrl == null) {
            log.error("can't find find baseUrl, might hava a bug! service={}", (Object)service);
        }
        if (Objects.isNull(circuitBreaker = (CircuitBreaker)this.circuitBreakerRegistry.find(this.parseResourceName(invocation.method(), baseUrl)).orElse(null))) {
            return chain.proceed(request);
        }
        StopWatch stopWatch = StopWatch.start();
        try {
            circuitBreaker.acquirePermission();
            Response response = chain.proceed(request);
            circuitBreaker.onResult(stopWatch.stop().toNanos(), TimeUnit.NANOSECONDS, (Object)response);
            return response;
        }
        catch (CallNotPermittedException e) {
            throw new RetrofitBlockException(e);
        }
        catch (Throwable throwable) {
            circuitBreaker.onError(stopWatch.stop().toNanos(), TimeUnit.NANOSECONDS, throwable);
            throw throwable;
        }
    }
}

