/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.BaseUrlParser;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitClient;
import java.util.Objects;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DefaultBaseUrlParser
implements BaseUrlParser {
    String SUFFIX = "/";
    String HTTP_PREFIX = "http://";

    @Override
    public String parse(RetrofitClient retrofitClient, Environment environment) {
        Object baseUrl = Objects.requireNonNull(retrofitClient).baseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            if (!((String)(baseUrl = environment.resolveRequiredPlaceholders((String)baseUrl))).endsWith(this.SUFFIX)) {
                baseUrl = (String)baseUrl + this.SUFFIX;
            }
        } else {
            String serviceId = retrofitClient.serviceId();
            Object path = retrofitClient.path();
            if (!((String)path).endsWith(this.SUFFIX)) {
                path = (String)path + this.SUFFIX;
            }
            baseUrl = this.HTTP_PREFIX + (serviceId + this.SUFFIX + (String)path).replaceAll("/+", this.SUFFIX);
            baseUrl = environment.resolveRequiredPlaceholders((String)baseUrl);
        }
        return baseUrl;
    }
}

