/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.config.GlobalTimeoutProperty;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.core.BaseUrlParser;
import com.github.lianjiatech.retrofit.spring.boot.core.BodyCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.InternalCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.ResponseCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.MonoCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava2CompletableCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava2SingleCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava3CompletableCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava3SingleCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeProxy;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegrade;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.Intercept;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.Intercepts;
import com.github.lianjiatech.retrofit.spring.boot.util.AppContextUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.BeanExtendUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationContextAware {
    private final Class<T> retrofitInterface;
    private Environment environment;
    private RetrofitConfigBean retrofitConfigBean;
    private ApplicationContext applicationContext;
    public static final ConcurrentHashMap<Class<?>, String> BASE_URL_MAP = new ConcurrentHashMap();

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public T getObject() {
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation(this.retrofitInterface, RetrofitClient.class);
        BaseUrlParser baseUrlParser = AppContextUtils.getBeanOrNew(this.applicationContext, retrofitClient.baseUrlParser());
        String baseUrl = baseUrlParser.parse(retrofitClient, this.environment);
        BASE_URL_MAP.put(this.retrofitInterface, baseUrl);
        Object source = this.createRetrofit(retrofitClient, baseUrl).create(this.retrofitInterface);
        if (!this.isEnableDegrade(this.retrofitInterface)) {
            return (T)source;
        }
        this.retrofitConfigBean.getRetrofitDegrade().loadDegradeRules(this.retrofitInterface, baseUrl);
        return DegradeProxy.create(source, this.retrofitInterface, this.applicationContext);
    }

    public boolean isEnableDegrade(Class<?> retrofitInterface) {
        RetrofitDegrade retrofitDegrade = this.retrofitConfigBean.getRetrofitDegrade();
        if (retrofitDegrade == null) {
            return false;
        }
        return retrofitDegrade.isEnableDegrade(retrofitInterface);
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder okHttpClientBuilder;
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation(this.retrofitInterface, RetrofitClient.class);
        if ("".equals(Objects.requireNonNull(retrofitClient).sourceOkHttpClient())) {
            GlobalTimeoutProperty globalTimeout = this.retrofitConfigBean.getRetrofitProperties().getGlobalTimeout();
            int connectTimeoutMs = retrofitClient.connectTimeoutMs() == -1 ? globalTimeout.getConnectTimeoutMs() : retrofitClient.connectTimeoutMs();
            int readTimeoutMs = retrofitClient.readTimeoutMs() == -1 ? globalTimeout.getReadTimeoutMs() : retrofitClient.readTimeoutMs();
            int writeTimeoutMs = retrofitClient.writeTimeoutMs() == -1 ? globalTimeout.getWriteTimeoutMs() : retrofitClient.writeTimeoutMs();
            int callTimeoutMs = retrofitClient.callTimeoutMs() == -1 ? globalTimeout.getCallTimeoutMs() : retrofitClient.callTimeoutMs();
            okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS).readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS).callTimeout((long)callTimeoutMs, TimeUnit.MILLISECONDS);
        } else {
            OkHttpClient sourceOkHttpClient = this.retrofitConfigBean.getSourceOkHttpClientRegistry().get(retrofitClient.sourceOkHttpClient());
            okHttpClientBuilder = sourceOkHttpClient.newBuilder();
        }
        if (this.isEnableDegrade(this.retrofitInterface)) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getRetrofitDegrade());
        }
        if (StringUtils.hasText((String)retrofitClient.serviceId())) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getServiceChooseInterceptor());
        }
        if (this.retrofitConfigBean.getRetrofitProperties().isEnableErrorDecoder()) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getErrorDecoderInterceptor());
        }
        this.findInterceptorByAnnotation().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        this.retrofitConfigBean.getGlobalInterceptors().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getRetryInterceptor());
        okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getLoggingInterceptor());
        this.retrofitConfigBean.getNetworkInterceptors().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addNetworkInterceptor(arg_0));
        return okHttpClientBuilder.build();
    }

    private List<Interceptor> findInterceptorByAnnotation() {
        Annotation[] classAnnotations = AnnotationUtils.getAnnotations(this.retrofitInterface);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : Objects.requireNonNull(classAnnotations)) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptMark.class)) {
                interceptAnnotations.add(classAnnotation);
            }
            if (!(classAnnotation instanceof Intercepts)) continue;
            Intercept[] value2 = ((Intercepts)classAnnotation).value();
            interceptAnnotations.addAll(Arrays.asList(value2));
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark annotations must be configured: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark annotations must be configured: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark annotations must be configured: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = AppContextUtils.getTargetInstanceIfNecessary((BasePathMatchInterceptor)AppContextUtils.getBeanOrNew(this.applicationContext, interceptorClass));
            HashMap annotationResolveAttributes = new HashMap(8);
            annotationAttributes.forEach((key, value) -> {
                if (value instanceof String) {
                    String newValue = this.environment.resolvePlaceholders((String)value);
                    annotationResolveAttributes.put(key, newValue);
                } else {
                    annotationResolveAttributes.put(key, value);
                }
            });
            BeanExtendUtils.populate(interceptor, annotationResolveAttributes);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private Retrofit createRetrofit(RetrofitClient retrofitClient, String baseUrl) {
        OkHttpClient client = this.createOkHttpClient();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).validateEagerly(retrofitClient.validateEagerly()).client(client);
        ArrayList<Class<? extends CallAdapter.Factory>> callAdapterFactories = new ArrayList<Class<? extends CallAdapter.Factory>>(2);
        callAdapterFactories.addAll(Arrays.asList(retrofitClient.callAdapterFactories()));
        callAdapterFactories.addAll(Arrays.asList(this.retrofitConfigBean.getGlobalCallAdapterFactoryClasses()));
        callAdapterFactories.stream().filter(adapterFactoryClass -> !InternalCallAdapterFactory.class.isAssignableFrom((Class<?>)adapterFactoryClass)).forEach(adapterFactoryClass -> retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)AppContextUtils.getBeanOrNew(this.applicationContext, adapterFactoryClass)));
        this.addReactiveCallAdapterFactory(retrofitBuilder);
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)ResponseCallAdapterFactory.INSTANCE);
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)BodyCallAdapterFactory.INSTANCE);
        ArrayList<Class<? extends Converter.Factory>> converterFactories = new ArrayList<Class<? extends Converter.Factory>>(4);
        converterFactories.addAll(Arrays.asList(retrofitClient.converterFactories()));
        converterFactories.addAll(Arrays.asList(this.retrofitConfigBean.getGlobalConverterFactoryClasses()));
        converterFactories.forEach(converterFactoryClass -> retrofitBuilder.addConverterFactory((Converter.Factory)AppContextUtils.getBeanOrNew(this.applicationContext, converterFactoryClass)));
        return retrofitBuilder.build();
    }

    private void addReactiveCallAdapterFactory(Retrofit.Builder retrofitBuilder) {
        if (this.reactor3ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)MonoCallAdapterFactory.INSTANCE);
        }
        if (this.rxjava2ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava2SingleCallAdapterFactory.INSTANCE);
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava2CompletableCallAdapterFactory.INSTANCE);
        }
        if (this.rxjava3ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava3SingleCallAdapterFactory.INSTANCE);
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava3CompletableCallAdapterFactory.INSTANCE);
        }
    }

    private boolean rxjava3ClassExist() {
        try {
            Class.forName("io.reactivex.rxjava3.core.Single");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean rxjava2ClassExist() {
        try {
            Class.forName("io.reactivex.Single");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean reactor3ClassExist() {
        try {
            Class.forName("reactor.core.publisher.Mono");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.retrofitConfigBean = (RetrofitConfigBean)applicationContext.getBean(RetrofitConfigBean.class);
    }
}

