/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade;

import com.github.lianjiatech.retrofit.spring.boot.degrade.HttpMethodPath;
import java.lang.reflect.Method;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;

public interface ResourceNameParser {
    public String parseResourceName(Method var1, String var2);

    default public HttpMethodPath parseHttpMethodPath(Method method) {
        HTTP http = method.getAnnotation(HTTP.class);
        if (http != null) {
            return new HttpMethodPath(http.method(), http.path());
        }
        GET get = method.getAnnotation(GET.class);
        if (get != null) {
            return new HttpMethodPath("GET", get.value());
        }
        POST post = method.getAnnotation(POST.class);
        if (post != null) {
            return new HttpMethodPath("POST", post.value());
        }
        PUT put = method.getAnnotation(PUT.class);
        if (put != null) {
            return new HttpMethodPath("PUT", put.value());
        }
        DELETE delete = method.getAnnotation(DELETE.class);
        if (delete != null) {
            return new HttpMethodPath("DELETE", delete.value());
        }
        HEAD head = method.getAnnotation(HEAD.class);
        if (head != null) {
            return new HttpMethodPath("HEAD", head.value());
        }
        PATCH patch = method.getAnnotation(PATCH.class);
        if (patch != null) {
            return new HttpMethodPath("PATCH", patch.value());
        }
        throw new UnsupportedOperationException("unsupported method!" + method);
    }
}

