/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.retry;

import com.github.lianjiatech.retrofit.spring.boot.exception.RetryFailedException;
import com.github.lianjiatech.retrofit.spring.boot.retry.GlobalRetryProperty;
import com.github.lianjiatech.retrofit.spring.boot.retry.Retry;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryRule;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryStrategy;
import com.github.lianjiatech.retrofit.spring.boot.util.AnnotationExtendUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Invocation;

public class RetryInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RetryInterceptor.class);
    protected final GlobalRetryProperty globalRetryProperty;

    public RetryInterceptor(GlobalRetryProperty globalRetryProperty) {
        this.globalRetryProperty = globalRetryProperty;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        if (invocation == null) {
            return chain.proceed(request);
        }
        Retry retry = AnnotationExtendUtils.findMergedAnnotation(invocation.method(), invocation.service(), Retry.class);
        if (!this.needRetry(retry)) {
            return chain.proceed(request);
        }
        int maxRetries = retry == null ? this.globalRetryProperty.getMaxRetries() : retry.maxRetries();
        int intervalMs = retry == null ? this.globalRetryProperty.getIntervalMs() : retry.intervalMs();
        RetryRule[] retryRules = retry == null ? this.globalRetryProperty.getRetryRules() : retry.retryRules();
        return this.retryIntercept(maxRetries, intervalMs, retryRules, chain);
    }

    protected boolean needRetry(Retry retry) {
        if (this.globalRetryProperty.isEnable()) {
            if (retry == null) {
                return true;
            }
            return retry.enable();
        }
        return retry != null && retry.enable();
    }

    protected Response retryIntercept(int maxRetries, int intervalMs, RetryRule[] retryRules, Interceptor.Chain chain) {
        HashSet retryRuleSet = (HashSet)Arrays.stream(retryRules).collect(Collectors.toSet());
        RetryStrategy retryStrategy = new RetryStrategy(maxRetries, intervalMs);
        Request request = chain.request();
        Response response = null;
        while (true) {
            try {
                while (true) {
                    response = chain.proceed(request);
                    if (!retryRuleSet.contains((Object)RetryRule.RESPONSE_STATUS_NOT_2XX) || response.isSuccessful()) {
                        return response;
                    }
                    if (!retryStrategy.shouldRetry()) {
                        return response;
                    }
                    retryStrategy.retry();
                    log.warn("The response fails, retry is performed! The request is {}, Response is {}", (Object)request, (Object)response);
                    response.close();
                }
            }
            catch (Exception e) {
                if (this.shouldThrowEx(retryRuleSet, e)) {
                    throw new RuntimeException(e);
                }
                if (!retryStrategy.shouldRetry()) {
                    throw new RetryFailedException("Retry Failed: Total " + maxRetries + " attempts made at interval " + intervalMs + "ms", e);
                }
                retryStrategy.retry();
                log.warn("The response fails, retry is performed! The request is {} ", (Object)request, (Object)e);
                if (response == null || response.body() == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    protected boolean shouldThrowEx(HashSet<RetryRule> retryRuleSet, Exception e) {
        if (retryRuleSet.contains((Object)RetryRule.OCCUR_EXCEPTION)) {
            return false;
        }
        if (retryRuleSet.contains((Object)RetryRule.OCCUR_IO_EXCEPTION)) {
            return !(e instanceof IOException);
        }
        return true;
    }
}

