/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.util.CellAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HSSFSaxReadHandler<T>
extends AbstractReadHandler<T>
implements HSSFListener {
    private static final Logger log = LoggerFactory.getLogger(HSSFSaxReadHandler.class);
    private String sheetName;
    private final POIFSFileSystem fs;
    private int lastRowNumber = -1;
    private final boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private int sheetIndex = -1;
    private BoundSheetRecord[] orderedBSRs;
    private final List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private final Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping;
    private Map<CellAddress, String> mergeFirstCellMapping;
    private boolean detectedMergeOfThisSheet;
    private long waitCount = 0L;

    public HSSFSaxReadHandler(File file, List<T> result, SaxExcelReader.ReadConfig<T> readConfig, Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping) throws IOException {
        super(false, result, readConfig, Collections.emptyMap());
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this.mergeCellIndexMapping = mergeCellIndexMapping;
    }

    public void process() throws IOException {
        long startTime = System.currentTimeMillis();
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)this.formatListener);
        factory.processWorkbookEvents(request, this.fs);
        log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public void processRecord(Record record) {
        boolean isSelectedSheet;
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.sheetIndex;
                this.setRecordAsNull();
                this.lastRowNumber = -1;
                this.titles = new LinkedHashMap();
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                }
                this.sheetName = this.orderedBSRs[this.sheetIndex].getSheetname();
                this.readConfig.startSheetConsumer.accept(this.sheetName, this.sheetIndex);
                this.mergeCellMapping = this.mergeCellIndexMapping.getOrDefault(this.sheetIndex, Collections.emptyMap());
                this.detectedMergeOfThisSheet = !this.mergeCellMapping.isEmpty();
                this.waitCount = 0L;
                this.mergeFirstCellMapping = this.mergeCellMapping.values().stream().distinct().collect(Collectors.toMap(cellAddress -> cellAddress, c -> ""));
                this.setFieldHandlerFunction();
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = berec.isBoolean() ? String.valueOf(berec.getBooleanValue()) : null;
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (Double.isNaN(frec.getValue())) {
                    this.outputNextStringRecord = true;
                    this.nextRow = frec.getRow();
                    this.nextColumn = frec.getColumn();
                    break;
                }
                thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisStr = srec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                thisStr = lrec.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                if (this.sstRecord == null) break;
                thisStr = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                break;
            }
            case 28: {
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec);
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                break;
            }
        }
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
            thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            thisStr = null;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            LastCellOfRowDummyRecord lc = (LastCellOfRowDummyRecord)record;
            thisRow = lc.getRow();
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastRowNumber = thisRow;
            this.newRow(thisRow, !this.detectedMergeOfThisSheet || this.waitCount == 0L);
            if (this.detectedMergeOfThisSheet && this.waitCount == 0L) {
                this.waitCount = this.mergeCellMapping.entrySet().stream().filter(c -> ((CellAddress)c.getValue()).getColumn() == 0 && Objects.equals(((CellAddress)c.getValue()).getRow(), this.lastRowNumber) && ((CellAddress)c.getKey()).getRow() != ((CellAddress)c.getValue()).getRow()).count() + 1L;
            }
            --this.waitCount;
        }
        if ((isSelectedSheet = this.isSelectedSheet()) && thisColumn != -1) {
            if (this.readConfig.detectedMerge) {
                CellAddress cellAddress2 = new CellAddress(thisRow, thisColumn);
                String finalThisStr = thisStr;
                this.mergeFirstCellMapping.computeIfPresent(cellAddress2, (k, v) -> finalThisStr);
                CellAddress firstCellAddress = (CellAddress)this.mergeCellIndexMapping.getOrDefault(this.sheetIndex, Collections.emptyMap()).get(cellAddress2);
                if (firstCellAddress != null) {
                    thisStr = this.mergeFirstCellMapping.get(firstCellAddress);
                }
            }
            this.handleField(thisColumn, thisStr);
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            if (!isSelectedSheet) {
                this.titles.clear();
                return;
            }
            if (!this.detectedMergeOfThisSheet || this.waitCount == 0L) {
                this.handleResult();
            }
        }
    }

    private boolean isSelectedSheet() {
        if (this.readConfig.readAllSheet) {
            return true;
        }
        if (!this.readConfig.sheetNames.isEmpty()) {
            return this.readConfig.sheetNames.contains(this.sheetName);
        }
        return this.readConfig.sheetIndexs.contains(this.sheetIndex);
    }
}

