/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSSFSheetXMLHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(XSSFSheetXMLHandler.class);
    private final SharedStrings sharedStringsTable;
    private final SheetContentsHandler output;
    private boolean vIsOpen;
    private boolean isIsOpen;
    private xssfDataType nextDataType;
    private int rowNum;
    private int preRowNum = -1;
    private int nextRowNum;
    private String cellRef;
    private final boolean detectedMerge;
    private long waitCount = 0L;
    private final StringBuilder value = new StringBuilder(64);
    private final Map<CellAddress, CellAddress> mergeCellMapping;
    private final Map<CellAddress, String> mergeFirstCellMapping;

    public XSSFSheetXMLHandler(Map<CellAddress, CellAddress> mergeCellMapping, SharedStrings strings, SheetContentsHandler sheetContentsHandler) {
        this.mergeCellMapping = mergeCellMapping;
        this.detectedMerge = !mergeCellMapping.isEmpty();
        this.mergeFirstCellMapping = mergeCellMapping.values().stream().distinct().collect(Collectors.toMap(cellAddress -> cellAddress, c -> ""));
        this.sharedStringsTable = strings;
        this.output = sheetContentsHandler;
        this.nextDataType = xssfDataType.NUMBER;
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if (this.isTextTag(localName)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("c".equals(localName)) {
            this.nextDataType = xssfDataType.NUMBER;
            this.cellRef = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if ("b".equals(cellType)) {
                this.nextDataType = xssfDataType.BOOLEAN;
            } else if ("e".equals(cellType)) {
                this.nextDataType = xssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = xssfDataType.INLINE_STRING;
            } else if ("s".equals(cellType)) {
                this.nextDataType = xssfDataType.SST_STRING;
            } else if ("str".equals(cellType)) {
                this.nextDataType = xssfDataType.FORMULA;
            }
        } else if ("row".equals(localName)) {
            String rowNumStr = attributes.getValue("r");
            this.rowNum = rowNumStr != null ? Integer.parseInt(rowNumStr) - 1 : this.nextRowNum;
            if (this.rowNum - 1 != this.preRowNum) {
                for (int blankRowNum = this.preRowNum + 1; blankRowNum < this.rowNum; ++blankRowNum) {
                    this.output.startRow(blankRowNum, true);
                    this.output.endRow(blankRowNum);
                }
            }
            this.output.startRow(this.rowNum, !this.detectedMerge || this.waitCount == 0L);
            if (this.detectedMerge && this.waitCount == 0L) {
                this.waitCount = this.mergeCellMapping.entrySet().stream().filter(c -> ((CellAddress)c.getValue()).getColumn() == 0 && Objects.equals(((CellAddress)c.getValue()).getRow(), this.rowNum) && ((CellAddress)c.getKey()).getRow() != ((CellAddress)c.getValue()).getRow()).count() + 1L;
            }
            --this.waitCount;
            this.preRowNum = this.rowNum;
        } else if ("is".equals(localName)) {
            this.isIsOpen = true;
        } else if ("f".equals(localName) && this.nextDataType == xssfDataType.NUMBER) {
            this.nextDataType = xssfDataType.FORMULA;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        String thisStr = null;
        if (this.isTextTag(localName)) {
            this.vIsOpen = false;
            switch (this.nextDataType) {
                case BOOLEAN: {
                    char first = this.value.charAt(0);
                    thisStr = first == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    thisStr = "ERROR:" + this.value;
                    break;
                }
                case FORMULA: {
                    thisStr = this.value.toString();
                    break;
                }
                case INLINE_STRING: {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                    thisStr = rtsi.toString();
                    break;
                }
                case SST_STRING: {
                    String sstIndex = this.value.toString();
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        RichTextString rtss = this.sharedStringsTable.getItemAt(idx);
                        thisStr = rtss.toString();
                    }
                    catch (NumberFormatException ex) {
                        logger.error("Failed to parse SST index '" + sstIndex, (Throwable)ex);
                    }
                    break;
                }
                case NUMBER: {
                    String n = this.value.toString();
                    if (n.contains(".")) {
                        n = String.valueOf(Double.parseDouble(n));
                    }
                    thisStr = n;
                    break;
                }
                default: {
                    thisStr = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            CellAddress cellAddress = new CellAddress(this.cellRef);
            String finalThisStr = thisStr;
            this.mergeFirstCellMapping.computeIfPresent(cellAddress, (k, v) -> finalThisStr);
            this.output.cell(cellAddress, thisStr);
        } else if ("c".equals(localName)) {
            CellAddress cellAddress = new CellAddress(this.cellRef);
            CellAddress firstCellAddress = this.mergeCellMapping.get(cellAddress);
            if (firstCellAddress != null) {
                this.output.cell(cellAddress, this.mergeFirstCellMapping.get(firstCellAddress));
            }
        } else if ("row".equals(localName)) {
            if (!this.detectedMerge || this.waitCount == 0L) {
                this.output.endRow(this.rowNum);
            }
            this.nextRowNum = this.rowNum + 1;
        } else if ("sheetData".equals(localName)) {
            this.output.endSheet();
        } else if ("is".equals(localName)) {
            this.isIsOpen = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
    }

    public static interface SheetContentsHandler {
        public void startRow(int var1, boolean var2);

        public void endRow(int var1);

        public void cell(CellAddress var1, String var2);

        default public void endSheet() {
        }
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

