/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.ReadConverter;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class AbstractReadConverter<R>
implements ReadConverter<String, R> {
    protected static final WeakCache<String, DateTimeFormatter> DATE_TIME_FORMATTER_WEAK_CACHE = new WeakCache();
    protected static final WeakCache<String, ThreadLocal<SimpleDateFormat>> SIMPLE_DATE_FORMAT_WEAK_CACHE = new WeakCache();
    private static final Pattern PATTERN_DATE_NUMBER = Pattern.compile("^[1-9]\\d{10,}$");
    private static final Pattern PATTERN_DATE_DECIMAL = Pattern.compile("[0-9]+\\.*[0-9]*");
    private static final LocalDateTime START_LOCAL_DATE_TIME = LocalDateTime.of(1900, 1, 1, 0, 0, 0);

    @Override
    public R convert(String obj, Field field, ConvertContext convertContext) {
        int length;
        if (StringUtil.isBlank(obj)) {
            return null;
        }
        String trimContent = obj.trim();
        if (trimContent.startsWith("(") && trimContent.endsWith(")") && (length = trimContent.length()) > 2) {
            trimContent = "-" + trimContent.substring(1, length - 1);
        }
        return this.doConvert(trimContent, field, convertContext);
    }

    protected abstract R doConvert(String var1, Field var2, ConvertContext var3);

    protected String getDateFormatPattern(Field field, ConvertContext convertContext) {
        ExcelColumnMapping mapping = convertContext.excelColumnMappingMap.get(field);
        if (mapping == null) {
            return field.getType() == LocalDate.class ? convertContext.configuration.dateFormat : (field.getType() == LocalTime.class ? convertContext.configuration.localTimeFormat : convertContext.configuration.dateTimeFormat);
        }
        String format = mapping.format;
        if (!format.isEmpty()) {
            return format;
        }
        return field.getType() == LocalDate.class ? convertContext.configuration.dateFormat : (field.getType() == LocalTime.class ? convertContext.configuration.localTimeFormat : convertContext.configuration.dateTimeFormat);
    }

    protected boolean isDateNumber(String v) {
        return PATTERN_DATE_NUMBER.matcher(v).matches();
    }

    protected boolean isDateDecimalNumber(String v) {
        return PATTERN_DATE_DECIMAL.matcher(v).matches();
    }

    protected DateTimeFormatter getDateFormatFormatter(Field field, ConvertContext convertContext) {
        String dateFormatPattern = this.getDateFormatPattern(field, convertContext);
        DateTimeFormatter dateTimeFormatter = DATE_TIME_FORMATTER_WEAK_CACHE.get(dateFormatPattern);
        if (Objects.isNull(dateTimeFormatter)) {
            dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormatPattern);
            DATE_TIME_FORMATTER_WEAK_CACHE.cache(dateFormatPattern, dateTimeFormatter);
        }
        return dateTimeFormatter;
    }

    protected SimpleDateFormat getSimpleDateFormat(String dateFormatPattern) {
        ThreadLocal<SimpleDateFormat> tl = SIMPLE_DATE_FORMAT_WEAK_CACHE.get(dateFormatPattern);
        if (tl == null) {
            tl = ThreadLocal.withInitial(() -> new SimpleDateFormat(dateFormatPattern));
            SIMPLE_DATE_FORMAT_WEAK_CACHE.cache(dateFormatPattern, tl);
        }
        return tl.get();
    }

    protected long convertExcelNumberDateToMilli(String value) {
        BigDecimal bd = new BigDecimal(value);
        int days = bd.intValue();
        int seconds = (int)Math.round(bd.subtract(new BigDecimal(days)).doubleValue() * 24.0 * 3600.0);
        int hour = seconds / 3600;
        int secondsOfHours = hour * 3600;
        int minute = (seconds - secondsOfHours) / 60;
        int second = seconds - secondsOfHours - minute * 60;
        LocalDateTime localDateTime = START_LOCAL_DATE_TIME.plusDays(days - 2).plusHours(hour).plusMinutes(minute).plusSeconds(second);
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

