/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Csv {
    private final Path filePath;

    Csv(Path filePath) {
        this.filePath = filePath;
        byte[] bom = new byte[]{-17, -69, -65};
        try {
            Files.write(this.filePath, bom, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void write(Path target) {
        this.write(target, false);
    }

    public void write(Path target, boolean append) {
        try {
            if (!append && Files.exists(target, new LinkOption[0])) {
                boolean delSuccess = Files.deleteIfExists(target);
                if (!delSuccess) {
                    throw new IllegalStateException("can not delete file:" + target.getFileName());
                }
                Files.createFile(target, new FileAttribute[0]);
            }
            try (FileInputStream fis = new FileInputStream(this.filePath.toFile());
                 FileOutputStream fos = new FileOutputStream(target.toFile(), true);){
                int len;
                long size;
                if (append && Files.exists(target, new LinkOption[0]) && Files.size(target) > 0L && (size = fis.skip(3L)) != 3L) {
                    throw new IllegalStateException("Skip byte failure");
                }
                byte[] buffer = new byte[8192];
                while ((len = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        TempFileOperator.deleteTempFile(this.filePath);
    }
}

