/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.constant.FileType;
import com.github.liaochong.myexcel.core.constant.ImageFile;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.utils.ImageUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;

public class ImageWriteConverter
implements WriteConverter {
    @Override
    public Pair<Class, Object> convert(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        if (fieldVal instanceof String) {
            String path = (String)fieldVal;
            if (path.startsWith("http")) {
                return Pair.of(ImageFile.class, ImageUtil.getImageFromNetByUrl(path));
            }
            if (path.startsWith("data")) {
                return Pair.of(ImageFile.class, ImageUtil.generateImageFromBase64(path));
            }
            return Pair.of(ImageFile.class, new File(path));
        }
        if (fieldVal instanceof Path) {
            return Pair.of(ImageFile.class, ((Path)fieldVal).toFile());
        }
        return Pair.of(ImageFile.class, fieldVal);
    }

    @Override
    public boolean support(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        if (fieldType != File.class && fieldType != InputStream.class && fieldType != String.class) {
            return false;
        }
        ExcelColumnMapping mapping = convertContext.excelColumnMappingMap.get(field);
        return mapping != null && mapping.fileType == FileType.IMAGE;
    }
}

