/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import java.util.Properties;

public final class PropertyUtil {
    private static final WeakCache<ExcelColumnMapping, Properties> mappingCache = new WeakCache();
    private static final WeakCache<ExcelColumnMapping, Properties> reverseMappingCache = new WeakCache();
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public static Properties getProperties(ExcelColumnMapping excelColumnMapping) {
        return PropertyUtil.getProperties(excelColumnMapping, mappingCache, false);
    }

    public static Properties getReverseProperties(ExcelColumnMapping excelColumnMapping) {
        return PropertyUtil.getProperties(excelColumnMapping, reverseMappingCache, true);
    }

    private static Properties getProperties(ExcelColumnMapping excelColumnMapping, WeakCache<ExcelColumnMapping, Properties> mappingCache, boolean reverse) {
        Properties properties = mappingCache.get(excelColumnMapping);
        if (properties != null) {
            return properties;
        }
        String[] mappingGroups = excelColumnMapping.mapping.split(",");
        if (mappingGroups.length == 0) {
            mappingCache.cache(excelColumnMapping, EMPTY_PROPERTIES);
            return EMPTY_PROPERTIES;
        }
        properties = new Properties();
        for (String m : mappingGroups) {
            String[] mappingGroup = m.split(":");
            if (mappingGroup.length != 2) {
                throw new IllegalArgumentException("Illegal mapping:" + m);
            }
            if (reverse) {
                properties.setProperty(mappingGroup[1], mappingGroup[0]);
                continue;
            }
            properties.setProperty(mappingGroup[0], mappingGroup[1]);
        }
        mappingCache.cache(excelColumnMapping, properties);
        return properties;
    }
}

