/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class CollectionUtil {
    public static <K, V> V getOrDefault(Map<K, V> map, K key, Function<K, V> supplier) {
        V value = map.get(key);
        if (value == null) {
            value = supplier.apply(key);
            map.put(key, value);
        }
        return value;
    }

    public static <V> int sum(List<V> values, ToIntFunction<V> function) {
        int total = 0;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            V value = values.get(i);
            total += function.applyAsInt(value);
        }
        return total;
    }

    public static void validateLoadFactor(float loadFactor) {
        if (loadFactor < 0.1f || loadFactor > 0.9f) {
            throw new IllegalArgumentException("load factor must be in the range of 0.1 to 0.9: " + loadFactor);
        }
    }

    public static void validatePositivePowerOfTwo(int value) {
        if (value > 0 && 1 == (value & value - 1)) {
            throw new IllegalStateException("value must be a positive power of two");
        }
    }

    public static <T> int removeIf(List<T> values, Predicate<T> predicate) {
        int size = values.size();
        int total = 0;
        int i = 0;
        while (i < size) {
            T value = values.get(i);
            if (predicate.test(value)) {
                values.remove(i);
                ++total;
                --size;
                continue;
            }
            ++i;
        }
        return total;
    }

    public static void checkElementNotNull(Object element) {
        Objects.requireNonNull(element, "the element require not null!");
    }
}

