/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class Hashing {
    private static final long C1 = -862048943L;
    private static final long C2 = 461845907L;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAX_TABLE_SIZE = 0x40000000;

    private Hashing() {
    }

    static int smear(int hashCode) {
        return (int)(461845907L * (long)Integer.rotateLeft((int)((long)hashCode * -862048943L), 15));
    }

    static int smearedHash(@Nullable Object o) {
        return Hashing.smear(o == null ? 0 : o.hashCode());
    }

    static int closedTableSize(int expectedEntries, double loadFactor) {
        int tableSize;
        if ((expectedEntries = Math.max(expectedEntries, 2)) > (int)(loadFactor * (double)(tableSize = Integer.highestOneBit(expectedEntries)))) {
            return (tableSize <<= 1) > 0 ? tableSize : 0x40000000;
        }
        return tableSize;
    }

    static boolean needsResizing(int size, int tableSize, double loadFactor) {
        return (double)size > loadFactor * (double)tableSize && tableSize < 0x40000000;
    }

    public static int hash(long value) {
        long hash = value * 31L;
        hash = (int)hash ^ (int)(hash >>> 32);
        return (int)hash;
    }

    public static int hash(int value, int mask) {
        int hash = value * 31;
        return hash & mask;
    }

    public static int evenHash(int value, int mask) {
        int hash = (value << 1) - (value << 8);
        return hash & mask;
    }
}

