/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.CollectionUtil;
import com.google.common.collect.Hashing;
import com.sun.istack.NotNull;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntArrayList
extends AbstractList<Integer>
implements List<Integer>,
RandomAccess,
Serializable {
    public static final int INITIAL_CAPACITY = 8;
    public static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private int size = 0;
    private int[] elements;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int initialCapacity) {
        this.elements = new int[Math.max(initialCapacity, 8)];
    }

    public IntArrayList(int[] initialElements, int initialSize) {
        this.wrap(initialElements, initialSize);
    }

    public void wrap(int[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("illegal initial size " + initialSize + " for array length of " + initialElements.length);
        }
        if (initialElements.length < 8) {
            throw new IllegalArgumentException("illegal initial array length " + initialElements.length + ", minimum required is " + 8);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 8) {
            this.elements = Arrays.copyOf(this.elements, Math.max(8, this.size));
        }
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    public int getInt(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(@NotNull Integer element) {
        CollectionUtil.checkElementNotNull(element);
        return this.addInt(element);
    }

    public boolean addInt(int element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, @NotNull Integer element) {
        CollectionUtil.checkElementNotNull(element);
        this.add(index, element);
    }

    public void addInt(int index, int element) {
        this.checkIndex(index);
        int requiredSize = this.size + 1;
        this.ensureCapacityPrivate(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Integer set(int index, @NotNull Integer element) {
        CollectionUtil.checkElementNotNull(element);
        return this.setInt(index, element);
    }

    public int setInt(int index, int element) {
        this.checkIndex(index);
        int previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    public boolean contains(int value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Integer remove(int index) {
        this.checkIndex(index);
        int value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public int fastUnorderedRemove(int index) {
        this.checkIndex(index);
        int value = this.elements[index];
        this.elements[index] = this.elements[--this.size];
        return value;
    }

    public boolean removeInt(int value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveInt(int value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.elements[index] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushInt(int element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
    }

    public int popInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedInt(IntConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.elements[i]);
        }
    }

    public IntStream intStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public int[] toIntArray(int[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        this.ensureCapacityPrivate(Math.max(requiredCapacity, 8));
    }

    public boolean equals(IntArrayList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getInt(i) == that.getInt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        boolean isEqual = false;
        if (other instanceof IntArrayList) {
            return this.equals((IntArrayList)other);
        }
        if (other instanceof List) {
            List that = (List)other;
            if (this.size == ((List)other).size()) {
                isEqual = true;
                int i = 0;
                for (Object o : that) {
                    Integer thatValue;
                    Integer thisValue;
                    if ((o == null || o instanceof Integer) && Objects.equals(thisValue = this.get(i++), thatValue = (Integer)o)) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.size; ++i) {
            int value = this.elements[i];
            hashCode = 31 * hashCode + Hashing.hash(value);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            int value = this.elements[i];
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    private void ensureCapacityPrivate(int requiredCapacity) {
        int currentCapacity = this.elements.length;
        if (requiredCapacity > currentCapacity) {
            int newCapacity = currentCapacity + (currentCapacity >> 1);
            if (newCapacity < 0 || newCapacity > Integer.MAX_VALUE) {
                if (currentCapacity == Integer.MAX_VALUE) {
                    throw new IllegalStateException("max capacity reached: 2147483647");
                }
                newCapacity = Integer.MAX_VALUE;
            }
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, currentCapacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }
}

