/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collector;

import com.google.common.collect.Int2IntHashMap;
import com.google.common.collect.IntArrayList;
import com.google.common.collect.IntHashSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class PrimitiveCollectors {
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private PrimitiveCollectors() {
    }

    public static Collector<Integer, ?, IntArrayList> toIntArrayList() {
        return new CollectorImpl(IntArrayList::new, IntArrayList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static Collector<Integer, ?, IntHashSet> toIntHashSet() {
        return new CollectorImpl(IntHashSet::new, IntHashSet::add, (left, right) -> {
            left.addAll((IntHashSet)right);
            return left;
        }, CH_ID);
    }

    public static <T, Integer, M extends Map<Integer, Integer>> Collector<Integer, ?, Int2IntHashMap> toInt2IntHashMap(Function<? super T, ? extends Integer> keyMapper, Function<? super T, ? extends Integer> valueMapper) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), PrimitiveCollectors.throwingMerger());
        return new CollectorImpl(Int2IntHashMap::new, accumulator, PrimitiveCollectors.mapMerger(PrimitiveCollectors.throwingMerger()), CH_ID);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapSupplier, accumulator, PrimitiveCollectors.mapMerger(mergeFunction), CH_ID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, PrimitiveCollectors.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

