/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page;

import com.github.liuanxin.page.dialect.Dialect;
import com.github.liuanxin.page.dialect.impl.MySqlDialect;
import com.github.liuanxin.page.dialect.impl.OracleDialect;
import com.github.liuanxin.page.model.PageBounds;
import com.github.liuanxin.page.model.PageList;
import com.github.liuanxin.page.util.PageUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageInterceptor
implements Interceptor {
    private static final Map<String, Class<? extends Dialect>> DIALECT_MAP = new HashMap<String, Class<? extends Dialect>>();
    private static final int MAPPED_INDEX = 0;
    private static final int PARAM_INDEX = 1;
    private static final int ROW_INDEX = 2;
    private Class<? extends Dialect> dialect;

    public PageInterceptor() {
    }

    public PageInterceptor(String dialect) {
        this.setDialect(dialect);
    }

    public Object intercept(final Invocation invocation) throws Throwable {
        Dialect dialectInstance;
        if (this.dialect == null) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        Object rowBounds = args[2];
        if (!(rowBounds instanceof PageBounds)) {
            return invocation.proceed();
        }
        final PageBounds page = (PageBounds)rowBounds;
        if (page.notNeedPage()) {
            return invocation.proceed();
        }
        final MappedStatement ms = (MappedStatement)args[0];
        final Object param = args[1];
        try {
            Constructor<? extends Dialect> constructor = this.dialect.getConstructor(MappedStatement.class, Object.class, PageBounds.class);
            Object[] constructor_params = new Object[]{ms, param, page};
            dialectInstance = constructor.newInstance(constructor_params);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instance dialect instance: " + this.dialect, e);
        }
        BoundSql boundSql = ms.getBoundSql(param);
        Integer count = null;
        if (page.isQueryTotal()) {
            count = PageUtil.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Executor executor = (Executor)invocation.getTarget();
                    String countSQL = dialectInstance.getCountSQL();
                    return PageUtil.getCount(executor, ms, param, page, countSQL);
                }
            });
        }
        List<ParameterMapping> mappings = dialectInstance.getParameterMappings();
        Object parameterObject = dialectInstance.getParameterObject();
        String pageSQL = dialectInstance.getPageSQL(count);
        args[0] = PageUtil.copyFromNewSql(ms, boundSql, pageSQL, mappings, parameterObject);
        args[1] = parameterObject;
        args[2] = RowBounds.DEFAULT;
        List list = PageUtil.submit(new Callable<List>(){

            @Override
            public List call() throws Exception {
                return (List)invocation.proceed();
            }
        });
        return count != null && count >= 0 ? new PageList(list, count) : list;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.setDialect(properties.getProperty("dialect"));
    }

    public PageInterceptor setDialect(String dialect) {
        if (dialect == null || "".equals(dialect.trim())) {
            throw new RuntimeException("must set dialect");
        }
        Class<? extends Dialect> clazz = DIALECT_MAP.get(dialect.toLowerCase());
        if (clazz == null) {
            throw new RuntimeException("no support db dialect with " + dialect);
        }
        this.dialect = clazz;
        return this;
    }

    static {
        DIALECT_MAP.put("mysql", MySqlDialect.class);
        DIALECT_MAP.put("oracle", OracleDialect.class);
    }
}

