/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect;

import com.github.liuanxin.page.model.PageBounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;

public class Dialect {
    protected static final String FOR_UPDATE = " FOR UPDATE";
    protected static final String ORDER_BY = " ORDER BY ";
    protected MappedStatement ms;
    protected PageBounds page;
    protected Object params;
    protected BoundSql boundSql;
    protected List<ParameterMapping> parameterMappings;
    protected Map<String, Object> pageParameters = new HashMap<String, Object>();
    protected String sql;

    public Dialect(MappedStatement mappedStatement, Object params, PageBounds page) {
        this.ms = mappedStatement;
        this.params = params;
        this.page = page;
        this.init();
    }

    protected void init() {
        this.boundSql = this.ms.getBoundSql(this.params);
        this.parameterMappings = new ArrayList<ParameterMapping>(this.boundSql.getParameterMappings());
        if (this.params instanceof Map) {
            this.pageParameters.putAll((Map)this.params);
        } else {
            for (ParameterMapping parameterMapping : this.parameterMappings) {
                this.pageParameters.put(parameterMapping.getProperty(), this.params);
            }
        }
        StringBuilder sbd = new StringBuilder(this.boundSql.getSql().trim());
        if (sbd.lastIndexOf(";") == sbd.length() - 1) {
            sbd.deleteCharAt(sbd.length() - 1);
        }
        this.sql = sbd.toString();
    }

    protected void setPageParameter(String name, Object value) {
        this.parameterMappings.add(new ParameterMapping.Builder(this.ms.getConfiguration(), name, Integer.class).build());
        this.pageParameters.put(name, value);
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public Object getParameterObject() {
        return this.pageParameters;
    }

    public String getPageSQL(Integer count) {
        if (this.page.notNeedPage()) {
            return this.sql;
        }
        this.page.pageWrong(count);
        return this.getLimitString(this.sql, "__offset", this.page.getOffset(), "__limit", this.page.getLimit());
    }

    public String getCountSQL() {
        String countSql = this.sql;
        String upperCase = countSql.toUpperCase();
        if (upperCase.endsWith(FOR_UPDATE)) {
            countSql = countSql.substring(0, countSql.length() - FOR_UPDATE.length());
        }
        if (upperCase.contains(ORDER_BY)) {
            countSql = countSql.substring(0, upperCase.indexOf(ORDER_BY));
        }
        return "SELECT COUNT(1) FROM (" + countSql + ") TEMP_COUNT";
    }

    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        throw new UnsupportedOperationException("Must set Dialect! Just like MySql Oracle etc.");
    }
}

