/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.model;

import java.io.Serializable;
import org.apache.ibatis.session.RowBounds;

public class PageBounds
extends RowBounds
implements Serializable {
    private int page = 1;
    private int limit = 15;
    private boolean queryTotal = false;
    private boolean checkPage = false;

    public PageBounds() {
    }

    public PageBounds(int limit) {
        this.limit = limit;
    }

    public PageBounds(int page, int limit) {
        this.page = page;
        this.limit = limit;
        this.queryTotal = true;
    }

    public PageBounds(int limit, boolean checkPage) {
        this.limit = limit;
        this.checkPage = checkPage;
    }

    public PageBounds(int page, int limit, boolean checkPage) {
        this.page = page;
        this.limit = limit;
        this.queryTotal = true;
        this.checkPage = checkPage;
    }

    public boolean notNeedPage() {
        return this.getOffset() == 0 && this.limit == Integer.MAX_VALUE;
    }

    public void pageWrong(Integer count) {
        if (this.checkPage && count != null && count > 0 && count <= this.limit && this.page > 1) {
            this.page = 1;
        }
    }

    public PageBounds setPage(int page) {
        this.page = page;
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public PageBounds setQueryTotal(boolean queryTotal) {
        this.queryTotal = queryTotal;
        return this;
    }

    public boolean isQueryTotal() {
        return this.queryTotal;
    }

    public PageBounds setCheckPage(boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public boolean isCheckPage() {
        return this.checkPage;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.page > 0 ? (this.page - 1) * this.limit : 0;
    }

    public String toString() {
        return String.format("(page: %s, limit: %s, queryTotal: %s)", this.page, this.limit, this.queryTotal);
    }
}

