/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.render;

import com.github.liuanxin.page.model.PageList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PageListToPageInterceptor
implements HandlerInterceptor {
    private static final String SUFFIX = "Total";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            HashMap<String, Integer> newModel = new HashMap<String, Integer>();
            for (Map.Entry item : modelAndView.getModel().entrySet()) {
                Object value = item.getValue();
                if (!(value instanceof PageList)) continue;
                newModel.put((String)item.getKey() + SUFFIX, ((PageList)value).getTotal());
            }
            if (!newModel.isEmpty()) {
                modelAndView.addAllObjects(newModel);
            }
        }
        Enumeration enumeration = request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name;
            Object attribute;
            Object element = enumeration.nextElement();
            if (!(element instanceof String) || !((attribute = request.getAttribute(name = (String)element)) instanceof PageList)) continue;
            request.setAttribute(name + SUFFIX, (Object)((PageList)attribute).getTotal());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

