/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect;

import com.github.liuanxin.page.model.PageBounds;
import java.util.regex.Pattern;

public class Dialect {
    private static final String FOR_UPDATE = " FOR UPDATE";
    private static final String ORDER_BY = "ORDER BY ";
    private static final Pattern BLANK_REGEX = Pattern.compile("\\s{2,}");
    protected PageBounds page;
    private String sql;

    public Dialect(String sql, PageBounds page) {
        this.page = page;
        StringBuilder sbd = new StringBuilder(sql);
        if (sbd.lastIndexOf(";") == sbd.length() - 1) {
            sbd.deleteCharAt(sbd.length() - 1);
        }
        this.sql = BLANK_REGEX.matcher(sbd.toString()).replaceAll(" ").trim();
    }

    public String getPageSQL(Integer count) {
        if (this.page.notNeedPage()) {
            return this.sql;
        }
        this.page.pageWrong(count);
        String limitSql = this.sql;
        boolean hasForUpdate = false;
        String upperCase = limitSql.toUpperCase();
        if (upperCase.endsWith(FOR_UPDATE)) {
            limitSql = this.sql.substring(0, this.sql.length() - FOR_UPDATE.length());
            hasForUpdate = true;
        }
        limitSql = this.getLimitString(limitSql, this.page.getOffset(), this.page.getLimit());
        if (hasForUpdate) {
            limitSql = limitSql + FOR_UPDATE;
        }
        return limitSql.trim();
    }

    public String getCountSQL() {
        String countSql = this.sql;
        String upperCase = countSql.toUpperCase();
        if (upperCase.endsWith(FOR_UPDATE)) {
            countSql = countSql.substring(0, countSql.length() - FOR_UPDATE.length());
        }
        if (upperCase.contains(ORDER_BY)) {
            countSql = countSql.substring(0, upperCase.indexOf(ORDER_BY));
        }
        return "SELECT COUNT(*) FROM (" + countSql + ") TEMP_COUNT";
    }

    protected String getLimitString(String sql, int offset, int limit) {
        throw new UnsupportedOperationException("Must set Dialect! Just like MySql Oracle etc.");
    }
}

