/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect;

import com.github.liuanxin.page.dialect.Dialect;
import com.github.liuanxin.page.dialect.impl.H2Dialect;
import com.github.liuanxin.page.dialect.impl.MySqlDialect;
import com.github.liuanxin.page.dialect.impl.OracleDialect;
import com.github.liuanxin.page.dialect.impl.PostgreSQLDialect;
import com.github.liuanxin.page.dialect.impl.SQLServer2000Dialect;
import com.github.liuanxin.page.dialect.impl.SQLServer2005Dialect;
import com.github.liuanxin.page.dialect.impl.SQLServer2012Dialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;

public class DialectUtil {
    private static final Map<String, Class<? extends Dialect>> DIALECT_MAP = new HashMap<String, Class<? extends Dialect>>();

    public static Class<? extends Dialect> getDialect(String dialect) {
        return DIALECT_MAP.get(dialect.toLowerCase());
    }

    public static Class<? extends Dialect> getDbType(DataSource dataSource) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            String url = con.getMetaData().getURL();
            for (Map.Entry<String, Class<? extends Dialect>> entry : DIALECT_MAP.entrySet()) {
                if (!url.startsWith("jdbc:" + entry.getKey() + ":")) continue;
                Class<? extends Dialect> clazz = entry.getValue();
                return clazz;
            }
            Iterator<Map.Entry<String, Class<? extends Dialect>>> iterator = null;
            return iterator;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot load db type with datasource.", e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static {
        DIALECT_MAP.put("h2", H2Dialect.class);
        DIALECT_MAP.put("sqlite", MySqlDialect.class);
        DIALECT_MAP.put("mysql", MySqlDialect.class);
        DIALECT_MAP.put("mariadb", MySqlDialect.class);
        DIALECT_MAP.put("oracle", OracleDialect.class);
        DIALECT_MAP.put("postgresql", PostgreSQLDialect.class);
        DIALECT_MAP.put("sqlite", MySqlDialect.class);
        DIALECT_MAP.put("sqlserver", SQLServer2000Dialect.class);
        DIALECT_MAP.put("sqlserver2000", SQLServer2000Dialect.class);
        DIALECT_MAP.put("sqlserver2005", SQLServer2005Dialect.class);
        DIALECT_MAP.put("sqlserver2012", SQLServer2012Dialect.class);
    }
}

