/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect.impl;

class SqlServerUtil {
    private static final String SELECT = "SELECT ";
    private static final int SELECT_LEN = "SELECT ".length();
    private static final String DISTINCT = " DISTINCT ";
    private static final String SELECT_DISTINCT = "SELECT  DISTINCT ".replace("  ", " ");
    private static final int DISTINCT_LEN = SELECT_DISTINCT.length();
    private static final String ORDER_BY = "ORDER BY ";
    private static final String DEFAULT_ORDER_BY = " ORDER BY 1 ";

    SqlServerUtil() {
    }

    static String topPage(String sql, int limit) {
        String upperCase = sql.toUpperCase();
        int insertPoint = upperCase.indexOf(SELECT) + (upperCase.contains(DISTINCT) ? DISTINCT_LEN : SELECT_LEN);
        return new StringBuilder(10 + sql.length()).append(sql).insert(insertPoint, String.format(" TOP %d ", limit)).toString();
    }

    static String fetchNext(String sql, int offset, int limit) {
        StringBuilder sbd = new StringBuilder(50 + sql.length());
        sbd.append(sql).append(" ");
        if (!sql.toUpperCase().contains(ORDER_BY)) {
            sbd.append(DEFAULT_ORDER_BY);
        }
        sbd.append(" OFFSET ").append(offset).append(" ROWS");
        if (limit > 0) {
            sbd.append(" FETCH NEXT ").append(limit).append(" ROWS ONLY");
        }
        return sbd.toString();
    }

    static String rowNum(String sql, int offset, int limit) {
        StringBuilder sbd = new StringBuilder(50 + sql.length());
        sbd.append("select * from ( select ");
        if (SqlServerUtil.hasDistinct(sql)) {
            sbd.append(DISTINCT);
        }
        sbd.append(" top ").append(offset + limit);
        sbd.append(" row_number() over (").append(SqlServerUtil.orderBy(sql)).append(" rn_, ").append(SqlServerUtil.noSelectNoOrderSql(sql));
        sbd.append(" ) a_ where rn_ > ").append(offset).append(" and rn_ <= ").append(offset + limit);
        return sbd.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.contains(SELECT_DISTINCT);
    }

    private static String orderBy(String sql) {
        int orderByIndex = sql.toUpperCase().indexOf(ORDER_BY);
        return orderByIndex > 0 ? sql.substring(orderByIndex) : DEFAULT_ORDER_BY;
    }

    private static String noSelectNoOrderSql(String sql) {
        String upperCase = sql.toUpperCase();
        int start = upperCase.indexOf(SELECT) + SELECT_LEN;
        int end = upperCase.indexOf(ORDER_BY);
        if (end <= 0) {
            end = sql.length();
        }
        return sql.substring(start, end);
    }
}

