/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;

public class PageUtil {
    private static final List<ResultMapping> EMPTY_RESULT_MAPPINGS = new ArrayList<ResultMapping>(0);

    public static MappedStatement copyFromNewSql(MappedStatement ms, Object parameter, String sql, boolean countQuery) {
        String id = ms.getId();
        if (countQuery) {
            id = id + "_COUNT";
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, (SqlSource)new BoundSqlSqlSource(ms, parameter, sql), ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        if (countQuery) {
            ResultMap.Builder mapBuilder = new ResultMap.Builder(ms.getConfiguration(), id, Integer.class, EMPTY_RESULT_MAPPINGS);
            builder.resultMaps(Collections.singletonList(mapBuilder.build()));
        } else {
            builder.resultMaps(ms.getResultMaps());
        }
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private static class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        BoundSqlSqlSource(MappedStatement ms, Object parameter, String sql) {
            List parameterMappings = ms.getBoundSql(parameter).getParameterMappings();
            this.boundSql = new BoundSql(ms.getConfiguration(), sql, parameterMappings, parameter);
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

