/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect.impl;

import com.github.liuanxin.page.dialect.Dialect;
import com.github.liuanxin.page.dialect.impl.SqlServerUtil;
import com.github.liuanxin.page.model.PageBounds;

public class SQLServer2012Dialect
extends Dialect {
    public SQLServer2012Dialect(String sql, PageBounds pageBounds) {
        super(sql, pageBounds);
    }

    @Override
    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        if (offset > 0) {
            return this.fetchNext(sql, offsetName, offset, limitName, limit);
        }
        super.addPageParam(limitName, limit);
        return SqlServerUtil.topPage(sql);
    }

    private String fetchNext(String sql, String offsetName, int offset, String limitName, int limit) {
        StringBuilder sbd = new StringBuilder(50 + sql.length());
        sbd.append(sql).append(" ");
        if (!sql.toUpperCase().contains(" ORDER BY ")) {
            sbd.append(" ORDER BY 1 ");
        }
        sbd.append(" OFFSET ? ROWS");
        super.addPageParam(offsetName, offset);
        if (limit > 0) {
            sbd.append(" FETCH NEXT ? ROWS ONLY");
            super.addPageParam(limitName, limit);
        }
        return sbd.toString();
    }
}

