/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect.impl;

class SqlServerUtil {
    private static final String SELECT = "SELECT ";
    private static final int SELECT_LEN = "SELECT ".length();
    private static final String DISTINCT = " DISTINCT ";
    private static final String SELECT_DISTINCT = "SELECT DISTINCT ";
    private static final int DISTINCT_LEN = "SELECT DISTINCT ".length();
    static final String ORDER_BY = " ORDER BY ";
    static final String DEFAULT_ORDER_BY = " ORDER BY 1 ";

    SqlServerUtil() {
    }

    static String topPage(String sql) {
        String upperCase = sql.toUpperCase();
        int insertPoint = upperCase.indexOf(SELECT) + (upperCase.startsWith(SELECT_DISTINCT) ? DISTINCT_LEN : SELECT_LEN);
        return new StringBuilder(sql).insert(insertPoint, " TOP ? ").toString();
    }

    static String rowNum(String sql) {
        StringBuilder sbd = new StringBuilder(50 + sql.length());
        sbd.append("SELECT * FROM ( SELECT ");
        if (SqlServerUtil.hasDistinct(sql)) {
            sbd.append(DISTINCT);
        }
        sbd.append(" ROW_NUMBER() OVER (").append(SqlServerUtil.orderBy(sql)).append(") AS RN_, ");
        sbd.append(SqlServerUtil.noSelectNoOrderSql(sql));
        sbd.append(" ) A_ WHERE RN_ > ? AND RN_ <= ?");
        return sbd.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toUpperCase().contains(SELECT_DISTINCT);
    }

    private static String orderBy(String sql) {
        int orderByIndex = sql.toUpperCase().indexOf(ORDER_BY);
        return orderByIndex > 0 ? sql.substring(orderByIndex) : DEFAULT_ORDER_BY;
    }

    private static String noSelectNoOrderSql(String sql) {
        String upperCase = sql.toUpperCase();
        int start = upperCase.indexOf(SELECT) + (upperCase.contains(DISTINCT) ? DISTINCT_LEN : SELECT_LEN);
        int end = upperCase.indexOf(ORDER_BY);
        if (end <= 0) {
            end = sql.length();
        }
        return sql.substring(start, end);
    }
}

