/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page;

import com.github.liuanxin.page.dialect.Dialect;
import com.github.liuanxin.page.dialect.DialectUtil;
import com.github.liuanxin.page.model.PageBounds;
import com.github.liuanxin.page.model.PageList;
import com.github.liuanxin.page.util.PageUtil;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageInterceptor
implements Interceptor {
    private static final int MAPPED_INDEX = 0;
    private static final int PARAM_INDEX = 1;
    private static final int ROW_INDEX = 2;
    private Class<? extends Dialect> dialect;

    public PageInterceptor() {
    }

    public PageInterceptor(String dialect) {
        this.setDialect(dialect);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Map<String, Object> pageParams;
        Dialect dialectInstance;
        Object[] args = invocation.getArgs();
        Object rowBounds = args[2];
        if (!(rowBounds instanceof PageBounds)) {
            return invocation.proceed();
        }
        PageBounds page = (PageBounds)rowBounds;
        if (page.notNeedPage()) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)args[0];
        if (this.dialect == null) {
            this.loadDialectWithDataSource(ms);
        }
        Object param = args[1];
        try {
            Constructor<? extends Dialect> constructor = this.dialect.getConstructor(String.class, PageBounds.class);
            dialectInstance = constructor.newInstance(ms.getBoundSql(param).getSql(), page);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instance dialect instance: " + this.dialect, e);
        }
        args[2] = RowBounds.DEFAULT;
        Integer count = null;
        if (page.isQueryTotal()) {
            String countSQL = dialectInstance.getCountSQL();
            pageParams = dialectInstance.getPageParams();
            args[0] = PageUtil.copyFromNewSql(ms, param, countSQL, pageParams, true);
            List countObj = (List)invocation.proceed();
            if (countObj != null && countObj.size() > 0 && (count = (Integer)countObj.get(0)) != null && count == 0) {
                return new PageList(Collections.emptyList(), 0);
            }
        }
        String pageSQL = dialectInstance.getPageSQL(count);
        pageParams = dialectInstance.getPageParams();
        args[0] = PageUtil.copyFromNewSql(ms, param, pageSQL, pageParams, false);
        List list = (List)invocation.proceed();
        if (count == null) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return new PageList(Collections.emptyList(), count);
        }
        return new PageList(list, count);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialect = properties.getProperty("dialect");
        if (dialect != null && !"".equals(dialect)) {
            this.setDialect(dialect);
        }
    }

    public PageInterceptor setDialect(String dialect) {
        Class<? extends Dialect> clazz = DialectUtil.getDialect(dialect);
        if (clazz == null) {
            throw new RuntimeException("no support db dialect with " + dialect);
        }
        this.dialect = clazz;
        return this;
    }

    private void loadDialectWithDataSource(MappedStatement ms) {
        this.dialect = DialectUtil.getDbType(ms.getConfiguration().getEnvironment().getDataSource());
        if (this.dialect == null) {
            throw new RuntimeException("must have dialect info");
        }
    }
}

