/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.dialect;

import com.github.liuanxin.page.model.PageBounds;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Dialect {
    private static final String FOR_UPDATE = " FOR UPDATE";
    private static final String GROUP_BY = " GROUP BY ";
    private static final Pattern COUNT_REGEX = Pattern.compile("(?i)^SELECT (.*?) FROM ");
    private static final String COUNT = "SELECT COUNT(*) FROM ";
    private static final Pattern BLANK_REGEX = Pattern.compile("\\s{2,}");
    private static final String BLANK = " ";
    protected PageBounds page;
    private String sql;
    private Map<String, Object> pageParams;

    public Dialect(String sql, PageBounds page) {
        this.page = page;
        StringBuilder sbd = new StringBuilder(sql);
        if (sbd.lastIndexOf(";") == sbd.length() - 1) {
            sbd.deleteCharAt(sbd.length() - 1);
        }
        this.sql = BLANK_REGEX.matcher(sbd.toString()).replaceAll(BLANK).trim();
        this.pageParams = new LinkedHashMap<String, Object>();
    }

    protected void addPageParam(String name, Object value) {
        this.pageParams.put(name, value);
    }

    public Map<String, Object> getPageParams() {
        return this.pageParams;
    }

    public String getPageSQL(Integer count) {
        if (this.page.notNeedPage()) {
            return this.sql;
        }
        this.page.pageWrong(count);
        String limitSql = this.sql;
        boolean hasForUpdate = false;
        String upperCase = limitSql.toUpperCase();
        if (upperCase.endsWith(FOR_UPDATE)) {
            limitSql = this.sql.substring(0, this.sql.length() - FOR_UPDATE.length());
            hasForUpdate = true;
        }
        limitSql = this.getLimitString(limitSql, "_offset_", this.page.getOffset(), "_limit_", this.page.getLimit());
        if (hasForUpdate) {
            limitSql = limitSql + FOR_UPDATE;
        }
        return limitSql.trim();
    }

    public String getCountSQL() {
        String countSql = this.sql;
        String upperCase = countSql.toUpperCase();
        if (upperCase.endsWith(FOR_UPDATE)) {
            countSql = countSql.substring(0, countSql.length() - FOR_UPDATE.length());
        }
        if (upperCase.contains(GROUP_BY)) {
            return "SELECT COUNT(*) FROM  (" + countSql + ") TEMP_COUNT";
        }
        return COUNT_REGEX.matcher(countSql).replaceFirst(COUNT);
    }

    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        throw new UnsupportedOperationException("Must set Dialect! Just like MySql Oracle etc.");
    }
}

