/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.model;

import java.io.Serializable;
import org.apache.ibatis.session.RowBounds;

public class PageBounds
extends RowBounds
implements Serializable {
    private int page = 1;
    private int limit = 15;
    private boolean queryTotal = false;
    private boolean checkPage = false;

    public PageBounds() {
    }

    public PageBounds(int limit) {
        this.limit = limit;
    }

    public PageBounds(int page, int limit) {
        this.page = page;
        this.limit = limit;
        this.queryTotal = true;
    }

    public PageBounds(int page, int limit, boolean queryTotal) {
        this.page = page;
        this.limit = limit;
        this.queryTotal = queryTotal;
    }

    public PageBounds(int limit, boolean checkPage) {
        this.limit = limit;
        this.checkPage = checkPage;
    }

    public PageBounds(int page, int limit, boolean queryTotal, boolean checkPage) {
        this.page = page;
        this.limit = limit;
        this.queryTotal = queryTotal;
        this.checkPage = checkPage;
    }

    public boolean notNeedPage() {
        return this.getOffset() == 0 && this.limit == Integer.MAX_VALUE;
    }

    public void pageWrong(Integer count) {
        if (this.checkPage && count != null && count > 0 && count <= this.limit && this.page > 1) {
            this.page = 1;
        }
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public void setQueryTotal(boolean queryTotal) {
        this.queryTotal = queryTotal;
    }

    public boolean isQueryTotal() {
        return this.queryTotal;
    }

    public void setCheckPage(boolean checkPage) {
        this.checkPage = checkPage;
    }

    public boolean isCheckPage() {
        return this.checkPage;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.page > 0 ? (this.page - 1) * this.limit : 0;
    }

    public String toString() {
        return String.format("(page: %s, limit: %s, queryTotal: %s, checkPage: %s)", this.page, this.limit, this.queryTotal, this.checkPage);
    }
}

