/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuanxin.page.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class PageUtil {
    private static final List<ResultMapping> EMPTY_RESULT_MAPPINGS = new ArrayList<ResultMapping>(0);

    public static MappedStatement copyFromNewSql(MappedStatement ms, Object parameter, String sql, Map<String, Object> pageParams, boolean countQuery) {
        String id = ms.getId();
        if (countQuery) {
            id = id + "_COUNT";
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, (SqlSource)new BoundSqlSqlSource(ms, parameter, sql, pageParams, countQuery), ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        if (countQuery) {
            ResultMap.Builder mapBuilder = new ResultMap.Builder(ms.getConfiguration(), id, Integer.class, EMPTY_RESULT_MAPPINGS);
            builder.resultMaps(Collections.singletonList(mapBuilder.build()));
        } else {
            builder.resultMaps(ms.getResultMaps());
        }
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private static class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        BoundSqlSqlSource(MappedStatement ms, Object parameter, String sql, Map<String, Object> pageParams, boolean countQuery) {
            Object value;
            String key;
            Configuration config = ms.getConfiguration();
            BoundSql oldBoundSql = ms.getBoundSql(parameter);
            LinkedList<ParameterMapping> parameterMappings = oldBoundSql.getParameterMappings();
            if (parameterMappings == null || parameterMappings.size() == 0) {
                parameterMappings = new LinkedList<ParameterMapping>();
            }
            if (!countQuery && pageParams != null && pageParams.size() > 0) {
                for (Map.Entry<String, Object> entry : pageParams.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    parameterMappings.add(new ParameterMapping.Builder(config, key, value.getClass()).build());
                }
            }
            this.boundSql = new BoundSql(config, sql, parameterMappings, parameter);
            if (!countQuery && pageParams != null && pageParams.size() > 0) {
                for (Map.Entry<String, Object> entry : pageParams.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    this.boundSql.setAdditionalParameter(key, value);
                }
            }
            for (ParameterMapping mapping : parameterMappings) {
                String property = mapping.getProperty();
                if (!oldBoundSql.hasAdditionalParameter(property)) continue;
                this.boundSql.setAdditionalParameter(property, oldBoundSql.getAdditionalParameter(property));
            }
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

