/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.asserts;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public abstract class Assert {
    public static void assertTrue(boolean condition, Callable<String> loader) {
        if (!condition) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertTrue(boolean condition, String description) {
        Assert.assertTrue(condition, () -> description);
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, () -> null);
    }

    public static void assertFalse(boolean condition, Callable<String> loader) {
        if (condition) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertFalse(boolean condition, String description) {
        Assert.assertFalse(condition, () -> description);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition, () -> null);
    }

    public static void assertNotNull(Object obj, Callable<String> loader) {
        if (obj == null) {
            throw new NullPointerException(Assert.lazyLoad(loader));
        }
    }

    public static void assertNotNull(Object obj, String description) {
        Assert.assertNotNull(obj, () -> description);
    }

    public static void assertNotNull(Object obj) {
        Assert.assertNotNull(obj, () -> null);
    }

    public static void assertNull(Object obj, Callable<String> loader) {
        if (obj != null) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertNull(Object obj, String description) {
        Assert.assertNull(obj, () -> description);
    }

    public static void assertNull(Object obj) {
        Assert.assertNull(obj, () -> null);
    }

    public static void assertNotBlank(String s, Callable<String> loader) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertNotBlank(String s, String description) {
        Assert.assertNotBlank(s, () -> description);
    }

    public static void assertNotBlank(String s) {
        Assert.assertNotBlank(s, () -> null);
    }

    public static void assertBlank(String s, Callable<String> loader) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertBlank(String s, String description) {
        Assert.assertBlank(s, () -> description);
    }

    public static void assertBlank(String s) {
        Assert.assertBlank(s, () -> null);
    }

    public static void assertEmpty(Collection<?> collection, Callable<String> loader) {
        if (collection != null && !collection.isEmpty()) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertEmpty(Collection<?> collection, String description) {
        Assert.assertEmpty(collection, () -> description);
    }

    public static void assertEmpty(Collection<?> collection) {
        Assert.assertEmpty(collection, () -> null);
    }

    public static void assertNotEmpty(Collection<?> collection, Callable<String> loader) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertNotEmpty(Collection<?> collection, String description) {
        Assert.assertNotEmpty(collection, () -> description);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        Assert.assertNotEmpty(collection, () -> null);
    }

    public static void assertEquals(Object obj1, Object obj2, Callable<String> loader) {
        if (!Objects.equals(obj1, obj2)) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertEquals(Object obj1, Object obj2, String description) {
        Assert.assertEquals(obj1, obj2, () -> description);
    }

    public static void assertEquals(Object obj1, Object obj2) {
        Assert.assertEquals(obj1, obj2, () -> null);
    }

    public static void assertNotEquals(Object obj1, Object obj2, Callable<String> loader) {
        if (Objects.equals(obj1, obj2)) {
            throw new IllegalArgumentException(Assert.lazyLoad(loader));
        }
    }

    public static void assertNotEquals(Object obj1, Object obj2, String description) {
        Assert.assertNotEquals(obj1, obj2, () -> description);
    }

    public static void assertNotEquals(Object obj1, Object obj2) {
        Assert.assertNotEquals(obj1, obj2, () -> null);
    }

    private static String lazyLoad(Callable<String> callable) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("load description throw an unexpected exception", e);
        }
    }
}

