/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.bean;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public abstract class BeanUtils {
    public static <T> T clone(T bean) {
        try {
            return (T)BeanUtils.doClone(bean, Lists.newLinkedList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object doClone(Object bean, LinkedList<Object> visited) throws Exception {
        if (bean == null) {
            return null;
        }
        if (ClassUtils.isPrimitiveOrWrapper(bean.getClass())) {
            return bean;
        }
        if (bean instanceof String) {
            return bean;
        }
        if (bean instanceof Date) {
            return new Date(((Date)bean).getTime());
        }
        if (bean instanceof BigInteger) {
            return new BigInteger(bean.toString());
        }
        if (bean instanceof BigDecimal) {
            return new BigDecimal(bean.toString());
        }
        if (bean.getClass().isEnum()) {
            return bean;
        }
        if (bean.getClass().isArray()) {
            BeanUtils.pushReference(visited, bean);
            Object clone = BeanUtils.doCloneArray(bean, visited);
            BeanUtils.popReference(visited);
            return clone;
        }
        if (bean instanceof Map) {
            BeanUtils.pushReference(visited, bean);
            Map clone = BeanUtils.doCloneMap((Map)bean, visited);
            BeanUtils.popReference(visited);
            return clone;
        }
        if (bean instanceof Collection) {
            BeanUtils.pushReference(visited, bean);
            Collection clone = BeanUtils.doCloneCollection((Collection)bean, visited);
            BeanUtils.popReference(visited);
            return clone;
        }
        BeanUtils.pushReference(visited, bean);
        Object clone = BeanUtils.doCloneBean(bean, visited);
        BeanUtils.popReference(visited);
        return clone;
    }

    private static Object doCloneArray(Object array, LinkedList<Object> visited) throws Exception {
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        Object clone = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            Array.set(clone, i, BeanUtils.doClone(value, visited));
        }
        return clone;
    }

    private static Map doCloneMap(Map map, LinkedList<Object> visited) throws Exception {
        Map clone = (Map)map.getClass().newInstance();
        for (PropertyInfo property : BeanUtils.getAllProperties(map)) {
            String key = property.name;
            Object value = property.value;
            clone.put(key, BeanUtils.doClone(value, visited));
        }
        return clone;
    }

    private static Collection doCloneCollection(Collection col, LinkedList<Object> visited) throws Exception {
        Collection clone = (Collection)col.getClass().newInstance();
        for (Object value : col) {
            clone.add(BeanUtils.doClone(value, visited));
        }
        return clone;
    }

    private static Object doCloneBean(Object bean, LinkedList<Object> visited) throws Exception {
        Object clone = bean.getClass().newInstance();
        for (PropertyInfo property : BeanUtils.getAllProperties(bean)) {
            String propertyName = property.name;
            Object propertyValue = property.value;
            Class propertyClass = property.clazz;
            Method setMethod = BeanUtils.getSetMethod(bean, propertyName, propertyClass);
            if (setMethod == null) continue;
            setMethod.invoke(clone, BeanUtils.doClone(propertyValue, visited));
        }
        return clone;
    }

    private static List<PropertyInfo> getAllProperties(Object bean) throws Exception {
        ArrayList properties = Lists.newArrayList();
        if (bean instanceof Map) {
            Set entrySet = ((Map)bean).entrySet();
            for (Map.Entry entry : entrySet) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                Class<?> valueClass = value == null ? null : value.getClass();
                if (key == null) {
                    properties.add(new PropertyInfo(null, value, valueClass));
                    continue;
                }
                if (!(key instanceof String)) continue;
                properties.add(new PropertyInfo((String)key, value, valueClass));
            }
        } else {
            for (Method getMethod : BeanUtils.getAllGetMethods(bean)) {
                String propertyName = BeanUtils.getPropertyNameOfGetMethod(getMethod);
                Object value = getMethod.invoke(bean, new Object[0]);
                properties.add(new PropertyInfo(propertyName, value, getMethod.getReturnType()));
            }
        }
        return properties;
    }

    private static List<Method> getAllGetMethods(Object bean) {
        ArrayList getMethods = Lists.newArrayList();
        if (bean == null) {
            return getMethods;
        }
        Object[] methods = bean.getClass().getMethods();
        if (ArrayUtils.isEmpty((Object[])methods)) {
            return getMethods;
        }
        for (Object method : methods) {
            String propertyName;
            Method setMethod;
            if (!BeanUtils.isGetMethod((Method)method) || (setMethod = BeanUtils.getSetMethod(bean, propertyName = BeanUtils.getPropertyNameOfGetMethod((Method)method), ((Method)method).getReturnType())) == null) continue;
            getMethods.add(method);
        }
        return getMethods;
    }

    private static Method getSetMethod(Object bean, String propertyName, Class<?> paramType) {
        Method setMethod;
        if (bean == null || paramType == null) {
            return null;
        }
        String setMethodName = BeanUtils.getSetMethodNameOfPropertyName(propertyName);
        if (paramType.isPrimitive()) {
            setMethod = BeanUtils.getMethod(bean, setMethodName, paramType);
            if (setMethod == null) {
                setMethod = BeanUtils.getMethod(bean, setMethodName, ClassUtils.primitiveToWrapper(paramType));
            }
            if (setMethod == null) {
                return null;
            }
            if (!BeanUtils.isVoid(setMethod.getReturnType())) {
                return null;
            }
        } else if (ClassUtils.isPrimitiveWrapper(paramType)) {
            setMethod = BeanUtils.getMethod(bean, setMethodName, paramType);
            if (setMethod == null) {
                setMethod = BeanUtils.getMethod(bean, setMethodName, ClassUtils.wrapperToPrimitive(paramType));
            }
            if (setMethod == null) {
                return null;
            }
            if (!BeanUtils.isVoid(setMethod.getReturnType())) {
                return null;
            }
        } else {
            setMethod = BeanUtils.getMethod(bean, setMethodName, paramType);
            if (setMethod == null) {
                return null;
            }
            if (!BeanUtils.isVoid(setMethod.getReturnType())) {
                return null;
            }
        }
        return setMethod;
    }

    private static String getPropertyNameOfGetMethod(Method getMethod) {
        String methodName = getMethod.getName();
        if (BeanUtils.isBoolean(getMethod.getReturnType())) {
            if (methodName.startsWith("is")) {
                return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            }
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    private static String getSetMethodNameOfPropertyName(String propertyName) {
        String setMethodName = "set";
        setMethodName = propertyName.length() == 1 ? setMethodName + propertyName.toUpperCase() : setMethodName + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return setMethodName;
    }

    private static boolean isGetMethod(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (BeanUtils.isVoid(returnType)) {
            return false;
        }
        String methodName = method.getName();
        if (BeanUtils.isBoolean(method.getReturnType())) {
            if (methodName.startsWith("is")) {
                return methodName.length() > 2;
            }
            if (methodName.startsWith("get")) {
                return methodName.length() > 3;
            }
            return false;
        }
        if (methodName.startsWith("get")) {
            return methodName.length() > 3;
        }
        return false;
    }

    private static boolean isVoid(Class<?> clazz) {
        return Void.TYPE.equals(clazz);
    }

    private static boolean isBoolean(Class<?> clazz) {
        return Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
    }

    private static Method getMethod(Object obj, String name, Class<?> ... parameterTypes) {
        try {
            return obj.getClass().getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static void pushReference(LinkedList<Object> visited, Object bean) {
        if (BeanUtils.containsReference(visited, bean)) {
            throw new RuntimeException("bean clone does not support mutual reference");
        }
        visited.push(bean);
    }

    private static void popReference(LinkedList<Object> visited) {
        visited.pop();
    }

    private static boolean containsReference(LinkedList<Object> visited, Object obj) {
        for (Object e : visited) {
            if (e != obj) continue;
            return true;
        }
        return false;
    }

    private static final class PropertyInfo {
        private final String name;
        private final Object value;
        private final Class<?> clazz;

        private PropertyInfo(String name, Object value, Class<?> clazz) {
            this.name = name;
            this.value = value;
            this.clazz = clazz;
        }
    }
}

